/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.healthcheck.license;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.event.ConfluenceLicenseUserLimitHealthCheckEvent;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.service.LicenseUserLimitService;
import com.atlassian.troubleshooting.healthcheck.util.LicenseUsageUtil;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LicenseUserLimitHealthCheck
implements SupportHealthCheck {
    private final LicenseService confluenceLicenseService;
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;
    private final UserChecker userChecker;
    private final LicenseUserLimitService licenseUserLimitService;
    private final I18nResolver i18nResolver;
    private final SupportApplicationInfo applicationInfo;
    private final EventPublisher eventPublisher;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public LicenseUserLimitHealthCheck(LicenseService confluenceLicenseService, SupportHealthStatusBuilder supportHealthStatusBuilder, UserChecker userChecker, LicenseUserLimitService licenseUserLimitService, I18nResolver i18nResolver, SupportApplicationInfo applicationInfo, EventPublisher eventPublisher) {
        this.confluenceLicenseService = Objects.requireNonNull(confluenceLicenseService);
        this.supportHealthStatusBuilder = Objects.requireNonNull(supportHealthStatusBuilder);
        this.userChecker = Objects.requireNonNull(userChecker);
        this.licenseUserLimitService = Objects.requireNonNull(licenseUserLimitService);
        this.i18nResolver = Objects.requireNonNull(i18nResolver);
        this.applicationInfo = Objects.requireNonNull(applicationInfo);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    public SupportHealthStatus check() {
        int numberOfTakenSeats = this.userChecker.getNumberOfRegisteredUsers();
        ConfluenceLicense license = this.confluenceLicenseService.retrieve();
        int numberOfSeats = license.getMaximumNumberOfUsers();
        LicenseUserLimitConfiguration licenseUserLimitConfiguration = this.licenseUserLimitService.getLicenseUserLimitConfig();
        LicenseUsageUtil.Threshold threshold = licenseUserLimitConfiguration.getIsPercentage() ? LicenseUsageUtil.Threshold.ofPercentage(licenseUserLimitConfiguration.getLimit()) : LicenseUsageUtil.Threshold.ofValue(licenseUserLimitConfiguration.getLimit());
        try {
            this.publishAnalyticsEvent(numberOfTakenSeats, numberOfSeats);
        }
        catch (Exception ex) {
            this.log.warn("failed publishing analytic event for license user limit health check", (Throwable)ex);
        }
        if (LicenseUsageUtil.isThresholdReached(numberOfTakenSeats, numberOfSeats, threshold)) {
            return this.getFailureStatusBuilder(threshold);
        }
        return this.supportHealthStatusBuilder.ok(this, this.getMessage(threshold, true), Integer.valueOf(threshold.getValue()));
    }

    private void publishAnalyticsEvent(int numberOfTakenSeats, int totalNumberOfSeats) {
        ConfluenceLicenseUserLimitHealthCheckEvent event = ((ConfluenceLicenseUserLimitHealthCheckEvent.Builder)((ConfluenceLicenseUserLimitHealthCheckEvent.Builder)ConfluenceLicenseUserLimitHealthCheckEvent.builder().licenseSeatLimit(totalNumberOfSeats)).seatsUsed(numberOfTakenSeats)).isInReadOnlyMode(this.userChecker.hasTooManyUsers()).build();
        this.eventPublisher.publish((Object)event);
    }

    private String getMessage(LicenseUsageUtil.Threshold threshold, boolean isHealthy) {
        String type = isHealthy ? "healthy" : "failure";
        String key = "confluence.healthcheck.license.user.limit.%s." + type;
        return String.format(key, threshold.isPercentage() ? "percentage" : "number");
    }

    private SupportHealthStatus getFailureStatusBuilder(LicenseUsageUtil.Threshold threshold) {
        SupportHealthStatusBuilder.Builder warning = this.supportHealthStatusBuilder.builder(this).severity(SupportHealthStatus.Severity.WARNING).i18nMessage(this.getMessage(threshold, false), Integer.valueOf(threshold.getValue()));
        this.addLinksToWarning(warning);
        return warning.build();
    }

    private void addLinksToWarning(SupportHealthStatusBuilder.Builder warning) {
        warning.additionalLink(this.i18nResolver.getText("confluence.healthcheck.license.user.limit.failure.user.management.text"), this.getUrl("/admin/users/showallusers.action"));
        warning.additionalLink(this.i18nResolver.getText("confluence.healthcheck.license.user.limit.failure.license.details.text"), this.getUrl(this.applicationInfo.getAdminLicenseUrl()));
    }

    private String getUrl(String endpoint) {
        return this.applicationInfo.getBaseURL(UrlMode.CANONICAL) + endpoint;
    }
}

