/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.healthcheck.synchrony;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.plugins.synchrony.api.SynchronyProcessManager;
import com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.http.HttpClientFactory;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SynchronyConnectivityHealthCheck
implements SupportHealthCheck {
    private static final String SYNCHRONY_SERVICE_URL_SYS_PROP = "synchrony.service.url";
    private static final Logger LOG = LoggerFactory.getLogger(SynchronyConnectivityHealthCheck.class);
    private static final int SYNCHRONY_HEARTBEAT_MAX_TIMEOUT_MS = 3000;
    private final BundleContext bundleContext;
    private final HttpClientFactory httpClientFactory;
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;
    private final ClusterManager clusterManager;

    @Autowired
    public SynchronyConnectivityHealthCheck(BundleContext bundleContext, HttpClientFactory httpClientFactory, SupportHealthStatusBuilder supportHealthStatusBuilder, ClusterManager clusterManager) {
        this.bundleContext = bundleContext;
        this.httpClientFactory = httpClientFactory;
        this.supportHealthStatusBuilder = supportHealthStatusBuilder;
        this.clusterManager = clusterManager;
    }

    @Override
    public SupportHealthStatus check() {
        try (SynchronyServiceWrapper synchronyServiceWrapper = new SynchronyServiceWrapper();){
            SynchronyProcessManager synchronyProcessManager = synchronyServiceWrapper.getProcessManager();
            SynchronyConfigurationManager synchronyConfigurationManager = synchronyServiceWrapper.getConfigManager();
            if (synchronyProcessManager.isSynchronyOff()) {
                SupportHealthStatus supportHealthStatus = this.supportHealthStatusBuilder.ok(this, "confluence.healthcheck.synchrony.connectivity.skip", new Serializable[0]);
                return supportHealthStatus;
            }
            boolean isSynchronyRunning = false;
            try {
                isSynchronyRunning = this.isSynchronyHeartBeating(synchronyConfigurationManager);
            }
            catch (IOException e) {
                LOG.warn("Failed to check Synchrony connectivity:", (Throwable)e);
            }
            SupportHealthStatus supportHealthStatus = this.createSynchronyStatus(isSynchronyRunning);
            return supportHealthStatus;
        }
    }

    private SupportHealthStatus createSynchronyStatus(boolean isSynchronyRunning) {
        if (isSynchronyRunning) {
            return this.supportHealthStatusBuilder.ok(this, "confluence.healthcheck.synchrony.connectivity.synchrony.ok", new Serializable[0]);
        }
        return this.supportHealthStatusBuilder.major(this, "confluence.healthcheck.synchrony.connectivity.synchrony.failed", new Serializable[0]);
    }

    private boolean isSynchronyHeartBeating(SynchronyConfigurationManager configurationManager) throws IOException {
        String heartBeatUrl = !this.clusterManager.isClustered() || this.clusterManager.isClustered() && StringUtils.isBlank((CharSequence)System.getProperty(SYNCHRONY_SERVICE_URL_SYS_PROP)) ? configurationManager.getInternalServiceUrl().replace("v1", "heartbeat") : String.format("%s/heartbeat", configurationManager.getExternalBaseUrl());
        int statusCode = this.httpClientFactory.newHttpClient(3000).execute((HttpUriRequest)new HttpGet(heartBeatUrl)).getStatusLine().getStatusCode();
        return statusCode == 200;
    }

    private final class SynchronyServiceWrapper
    implements AutoCloseable {
        private final ServiceReference<?> configManagerRef;
        private final ServiceReference<?> processManagerRef;

        SynchronyServiceWrapper() {
            this.configManagerRef = SynchronyConnectivityHealthCheck.this.bundleContext.getServiceReference("com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager");
            this.processManagerRef = SynchronyConnectivityHealthCheck.this.bundleContext.getServiceReference("com.atlassian.confluence.plugins.synchrony.api.SynchronyProcessManager");
        }

        @Override
        public void close() {
            if (this.getConfigManagerRef() != null) {
                SynchronyConnectivityHealthCheck.this.bundleContext.ungetService(this.configManagerRef);
            }
            if (this.getProcessManagerRef() != null) {
                SynchronyConnectivityHealthCheck.this.bundleContext.ungetService(this.processManagerRef);
            }
        }

        private ServiceReference<?> getConfigManagerRef() {
            return this.configManagerRef;
        }

        private ServiceReference<?> getProcessManagerRef() {
            return this.processManagerRef;
        }

        private SynchronyConfigurationManager getConfigManager() {
            return (SynchronyConfigurationManager)SynchronyConnectivityHealthCheck.this.bundleContext.getService(this.configManagerRef);
        }

        private SynchronyProcessManager getProcessManager() {
            return (SynchronyProcessManager)SynchronyConnectivityHealthCheck.this.bundleContext.getService(this.processManagerRef);
        }
    }
}

