/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import com.atlassian.plugins.cloud.connect.companion.client.IncompatibleServiceException;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.troubleshooting.dcdp.DcdpTransferService;
import com.atlassian.troubleshooting.dcdp.config.DcdpConfigStore;
import com.atlassian.troubleshooting.dcdp.config.JmxIpdStateProvider;
import com.atlassian.troubleshooting.dcdp.feature.DcdpTransferFeatureManager;
import com.atlassian.troubleshooting.dcdp.job.DcdpDataCollectionJob;
import com.atlassian.troubleshooting.dcdp.job.DcdpTransferJob;
import com.atlassian.troubleshooting.dcdp.transfer.DcdpDataSender;
import com.atlassian.troubleshooting.dcdp.transfer.data.DcdpDataHandler;
import com.atlassian.troubleshooting.dcdp.transfer.data.collector.DcdpDataCollector;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.DcdpTransferStatus;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.DcdpTransferSubmission;
import com.atlassian.troubleshooting.dcdp.utils.SchedulerDatesService;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.http.HttpStatus;

@Path(value="/dcdp")
@Produces(value={"application/json"})
@SystemAdminOnly
@Singleton
public class DcdpTransferResource {
    static final String WAS_CONFIGURED_KEY = "wasConfigured";
    private static final Set<String> SUPPORTED_APPS = ImmutableSet.of((Object)"Jira", (Object)"Confluence");
    private final DcdpTransferService dcdpTransferService;
    private final DcdpTransferFeatureManager dcdpTransferFeatureManager;
    private final DcdpDataSender dcdpDataSender;
    private final DcdpDataCollector dcdpDataCollector;
    private final DcdpDataHandler dcdpDataHandler;
    private final DcdpConfigStore dcdpConfigStore;
    private final SchedulerDatesService schedulerDatesService;
    private final SupportApplicationInfo applicationInfo;
    private final JmxIpdStateProvider jmxIpdStateProvider;

    @Inject
    public DcdpTransferResource(DcdpTransferService dcdpTransferService, DcdpTransferFeatureManager dcdpTransferFeatureManager, DcdpDataSender dcdpDataSender, DcdpDataCollector dcdpDataCollector, DcdpDataHandler dcdpDataHandler, DcdpConfigStore dcdpConfigStore, SchedulerDatesService schedulerDatesService, SupportApplicationInfo applicationInfo, JmxIpdStateProvider jmxIpdStateProvider) {
        this.dcdpTransferService = Objects.requireNonNull(dcdpTransferService);
        this.dcdpTransferFeatureManager = Objects.requireNonNull(dcdpTransferFeatureManager);
        this.dcdpDataSender = Objects.requireNonNull(dcdpDataSender);
        this.dcdpDataCollector = Objects.requireNonNull(dcdpDataCollector);
        this.dcdpDataHandler = Objects.requireNonNull(dcdpDataHandler);
        this.dcdpConfigStore = Objects.requireNonNull(dcdpConfigStore);
        this.schedulerDatesService = Objects.requireNonNull(schedulerDatesService);
        this.applicationInfo = Objects.requireNonNull(applicationInfo);
        this.jmxIpdStateProvider = Objects.requireNonNull(jmxIpdStateProvider);
    }

    @ExperimentalApi
    @GET
    @Path(value="status")
    public Response getStatus(@QueryParam(value="trace") boolean trace) {
        this.validateIhsAndProductAvailability();
        DcdpTransferStatus status = this.dcdpTransferService.status(trace);
        if (!status.isValid()) {
            return Response.status((int)HttpStatus.BAD_GATEWAY.value()).entity((Object)status).build();
        }
        return Response.ok().entity((Object)status).build();
    }

    @ExperimentalApi
    @POST
    @Path(value="analytics")
    public Response postAnalyticData(@QueryParam(value="trace") boolean trace) throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        if (!this.dcdpTransferFeatureManager.isIhsTestApiEnabled()) {
            throw new NotFoundException();
        }
        this.dcdpDataCollector.collectMultiplePerBatchData();
        DcdpTransferSubmission submission = this.dcdpDataSender.sendDiagnosticsData(trace);
        if (!submission.succeeded()) {
            return Response.status((int)HttpStatus.BAD_GATEWAY.value()).entity((Object)submission).build();
        }
        return Response.ok().entity((Object)submission).build();
    }

    @ExperimentalApi
    @GET
    @Path(value="healthupdates")
    public Response getHealthUpdates() {
        this.validateIhsAndProductAvailability();
        return Response.ok().header(DcdpDataCollectionJob.class.getName() + ".interval", (Object)DcdpDataCollectionJob.getInterval()).header(DcdpTransferJob.class.getName() + ".interval", (Object)DcdpTransferJob.getInterval()).entity(this.dcdpDataHandler.getDiagnosticsData()).build();
    }

    @ExperimentalApi
    @GET
    @Path(value="feature-state")
    public Response getDataSendingFeatureFlagState() {
        this.validateIhsAndProductAvailability();
        try {
            boolean isEnabled = this.dcdpTransferFeatureManager.isIhsSendDataFeatureEnabled();
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("enabled", String.valueOf(isEnabled));
            return Response.ok().entity(response).build();
        }
        catch (NullPointerException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Feature state could not be determined due to a server error.").build();
        }
    }

    @ExperimentalApi
    @GET
    @Path(value="upload-times")
    public Response getUploadTimes() {
        this.validateIhsAndProductAvailability();
        HashMap response = new HashMap();
        this.schedulerDatesService.getNextRunDateForJobKey(DcdpTransferJob.JOB_RUNNER_KEY).ifPresent(nextUpload -> response.put("nextUpload", nextUpload));
        this.schedulerDatesService.getLastSuccessfulRunDateForJobKey(DcdpTransferJob.JOB_RUNNER_KEY).ifPresent(lastUpload -> response.put("lastUpload", lastUpload));
        return Response.ok().entity(response).build();
    }

    @ExperimentalApi
    @POST
    @Path(value="toggle-feature")
    @Consumes(value={"application/json"})
    public Response toggleFeature(Map<String, Boolean> requestBody) {
        this.validateIhsAndProductAvailability();
        if (requestBody == null || !requestBody.containsKey("enabled")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing 'enabled' parameter").build();
        }
        Boolean enable = requestBody.get("enabled");
        if (enable == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'enabled' parameter must be a boolean").build();
        }
        try {
            this.dcdpTransferFeatureManager.changeIhsTransferState(enable);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not toggle feature state due to a server error.").build();
        }
    }

    @ExperimentalApi
    @GET
    @Path(value="node-hash-map")
    public Response getNodeHashMap() {
        this.validateIhsAndProductAvailability();
        return Response.ok().entity(this.dcdpDataHandler.getAllHashNodeIds()).build();
    }

    @ExperimentalApi
    @GET
    @Path(value="was-configured")
    public Response wasConfigured() {
        this.validateIhsAndProductAvailability();
        DcdpTransferStatus status = this.dcdpTransferService.status(false);
        if (status.isValid()) {
            this.setEstablishedConnectionKeyIfAbsent();
        }
        boolean isConfigured = "true".equals(this.dcdpConfigStore.get(WAS_CONFIGURED_KEY).orElse("false"));
        return Response.ok().entity((Object)isConfigured).build();
    }

    @ExperimentalApi
    @GET
    @Path(value="jmx-status")
    public Response isJmxEnabled() {
        this.validateIhsAndProductAvailability();
        boolean isEnabled = this.jmxIpdStateProvider.isJmxEnabled();
        return Response.ok().entity((Object)isEnabled).build();
    }

    @ExperimentalApi
    @GET
    @Path(value="ipd-status")
    public Response isIpdEnabled() {
        this.validateIhsAndProductAvailability();
        boolean isEnabled = this.jmxIpdStateProvider.isIpdEnabled();
        return Response.ok().entity((Object)isEnabled).build();
    }

    void validateIhsAndProductAvailability() throws NotFoundException {
        if (!SUPPORTED_APPS.contains(this.applicationInfo.getApplicationName()) || this.dcdpTransferFeatureManager.isIhsFeatureDisabled()) {
            throw new NotFoundException();
        }
    }

    private void setEstablishedConnectionKeyIfAbsent() {
        String currentStatus = String.valueOf(this.dcdpConfigStore.get(WAS_CONFIGURED_KEY));
        if (!"true".equals(currentStatus)) {
            this.dcdpConfigStore.store(WAS_CONFIGURED_KEY, "true");
        }
    }
}

