/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.config;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DcdpConfigStore {
    private static final String PREFIX_KEY = "ihs.properties:";
    private final PluginSettingsFactory pluginSettingsFactory;

    @Autowired
    public DcdpConfigStore(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = Objects.requireNonNull(pluginSettingsFactory);
    }

    public Optional<String> get(@Nonnull String ihsProperty) {
        return Optional.ofNullable(this.pluginSettingsFactory.createGlobalSettings().get(PREFIX_KEY + ihsProperty)).map(String.class::cast);
    }

    public void store(@Nonnull String ihsProperty, @Nullable String ihsValue) {
        this.pluginSettingsFactory.createGlobalSettings().put(PREFIX_KEY + ihsProperty, (Object)ihsValue);
    }
}

