/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.config;

import com.google.common.annotations.VisibleForTesting;
import jakarta.ws.rs.core.UriBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DcdpTransferConfig {
    public static final String X_TRACE_ID_HEADER = "X-Trace-Id";
    public static final String DCDP_HEALTH_UPDATE_PATH = "/analytics";
    public static final String DCDP_HEARTBEAT_PATH = "/heartbeat";
    @VisibleForTesting
    public static final String DCDP_PREFIX = "/dcdp";
    private static final String DEFAULT_CLOUD_API_URL = "api.atlassian.com";
    private static final String CLOUD_API_BASE_URL_PROPERTY = "dcdp.transfer.cloud.url";
    private static final String CLOUD_API_BASE_URL = System.getProperty("dcdp.transfer.cloud.url", "api.atlassian.com");
    private static final Logger LOG = LoggerFactory.getLogger(DcdpTransferConfig.class);

    public Optional<URL> getDcdpPublicUrl(String relativePath) {
        try {
            String apiScheme = CLOUD_API_BASE_URL.contains("localhost") ? "http" : "https";
            return Optional.of(UriBuilder.fromPath((String)(DCDP_PREFIX + relativePath)).host(CLOUD_API_BASE_URL).scheme(apiScheme).build(new Object[0]).toURL());
        }
        catch (MalformedURLException e) {
            LOG.error("Error creating the URL to call DCDP", (Throwable)e);
            return Optional.empty();
        }
    }
}

