/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.feature;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.troubleshooting.api.ClusterMessagingService;
import com.atlassian.troubleshooting.api.ListenerRegistration;
import com.atlassian.troubleshooting.dcdp.job.DcdpDataCollectionJob;
import com.atlassian.troubleshooting.dcdp.job.DcdpTransferJob;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ClusterIhsStateListener
implements LifecycleAware {
    public static final String IHS_CLUSTER_STATE_CHANNEL_NAME = "ihs_refresh";
    private static final Logger LOG = LoggerFactory.getLogger(ClusterIhsStateListener.class);
    private ListenerRegistration listenerRegistration;
    private final ClusterMessagingService clusterMessagingService;
    private final DcdpTransferJob dcdpTransferJob;
    private final DcdpDataCollectionJob dcdpDataCollectionJob;

    @Autowired
    public ClusterIhsStateListener(ClusterMessagingService clusterMessagingService, DcdpTransferJob dcdpTransferJob, DcdpDataCollectionJob dcdpDataCollectionJob) {
        this.clusterMessagingService = Objects.requireNonNull(clusterMessagingService);
        this.dcdpTransferJob = Objects.requireNonNull(dcdpTransferJob);
        this.dcdpDataCollectionJob = Objects.requireNonNull(dcdpDataCollectionJob);
    }

    public void onStart() {
        this.listenerRegistration = this.registerListener();
        LOG.info("ClusterIhsStateListener started");
    }

    public void onStop() {
        Optional.ofNullable(this.listenerRegistration).ifPresent(ListenerRegistration::unregister);
        LOG.info("ClusterIhsStateListener stopped");
    }

    private ListenerRegistration registerListener() {
        return this.clusterMessagingService.registerListener(IHS_CLUSTER_STATE_CHANNEL_NAME, ignore -> {
            LOG.info("Received IHS state refresh message");
            this.dcdpTransferJob.refreshState();
            this.dcdpDataCollectionJob.refreshState();
        });
    }
}

