/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.feature;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.troubleshooting.dcdp.feature.DcdpFeatureFlags;
import com.atlassian.troubleshooting.dcdp.feature.RefreshIhsStateRequestEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class DcdpTransferFeatureManager
implements LifecycleAware {
    public static final String ENABLED_SUFFIX = ".enabled";
    public static final String DISABLED_SUFFIX = ".disabled";
    public static final String IHS_FEATURE_KEY = "com.atlassian.troubleshooting.ihs";
    public static final String IHS_FEATURE_KEY_DISABLED = "com.atlassian.troubleshooting.ihs.disabled";
    public static final String IHS_FEATURE_KEY_ENABLED = "com.atlassian.troubleshooting.ihs.enabled";
    public static final String IHS_TEST_API_FEATURE_KEY = "com.atlassian.troubleshooting.ihs.test.api";
    public static final String IHS_TEST_API_FEATURE_KEY_ENABLED = "com.atlassian.troubleshooting.ihs.test.api.enabled";
    public static final String IHS_SEND_DATA_FEATURE_KEY = "com.atlassian.troubleshooting.cloud.publishing";
    public static final String IHS_SEND_DATA_FEATURE_KEY_ENABLED = "com.atlassian.troubleshooting.cloud.publishing.enabled";
    public static final String IHS_SEND_DATA_FEATURE_KEY_DISABLED = "com.atlassian.troubleshooting.cloud.publishing.disabled";
    public static final String RFU_METRICS_COLLECTION_FEATURE_KEY = "com.atlassian.troubleshooting.rfu.metrics.collection";
    public static final String RFU_METRICS_COLLECTION_FEATURE_KEY_ENABLED = "com.atlassian.troubleshooting.rfu.metrics.collection.enabled";
    public static final String RFU_METRICS_COLLECTION_FEATURE_KEY_DISABLED = "com.atlassian.troubleshooting.rfu.metrics.collection.disabled";
    private final DarkFeatureManager darkFeatureManager;
    private final EventPublisher eventPublisher;

    protected DcdpTransferFeatureManager(DarkFeatureManager darkFeatureManager, EventPublisher eventPublisher) {
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
    }

    public void onStop() {
        this.eventPublisher.unregister((Object)this);
    }

    public boolean isEnabled() {
        return !this.isIhsFeatureDisabled() && this.isIhsSendDataFeatureEnabled();
    }

    public DcdpFeatureFlags getIhsFeatureFlags() {
        return new DcdpFeatureFlags(this.isIhsFeatureDisabled(), this.isIhsSendDataFeatureEnabled());
    }

    public boolean isIhsFeatureDisabled() {
        Optional<Boolean> ihsFeatureFlagState = this.getExplicitStateOfFeatureFlag(IHS_FEATURE_KEY_DISABLED, IHS_FEATURE_KEY_ENABLED);
        return ihsFeatureFlagState.map(v -> v == false).orElseGet(() -> !this.isFeatureEnabledByDefault());
    }

    public boolean isIhsSendDataFeatureEnabled() {
        Optional<Boolean> ihsSendDataFeatureFlagState = this.getExplicitStateOfFeatureFlag(IHS_SEND_DATA_FEATURE_KEY_DISABLED, IHS_SEND_DATA_FEATURE_KEY_ENABLED);
        return ihsSendDataFeatureFlagState.orElseGet(this::isSendingEnabledByDefault);
    }

    public boolean isRfuMetricsCollectionFeatureEnabled() {
        Optional<Boolean> rfuCollectionFeatureFlagState = this.getExplicitStateOfFeatureFlag(RFU_METRICS_COLLECTION_FEATURE_KEY_DISABLED, RFU_METRICS_COLLECTION_FEATURE_KEY_ENABLED);
        return rfuCollectionFeatureFlagState.orElseGet(this::isRfuMetricsCollectionEnabledByDefault);
    }

    public boolean isIhsTestApiEnabled() {
        return !this.isIhsFeatureDisabled() && this.darkFeatureManager.isEnabledForAllUsers(IHS_TEST_API_FEATURE_KEY).orElse(false) != false;
    }

    public void changeIhsTransferState(boolean enabled) {
        if (enabled) {
            this.darkFeatureManager.disableFeatureForAllUsers(IHS_SEND_DATA_FEATURE_KEY_DISABLED);
            this.darkFeatureManager.enableFeatureForAllUsers(IHS_SEND_DATA_FEATURE_KEY_ENABLED);
        } else {
            this.darkFeatureManager.disableFeatureForAllUsers(IHS_SEND_DATA_FEATURE_KEY_ENABLED);
            this.darkFeatureManager.enableFeatureForAllUsers(IHS_SEND_DATA_FEATURE_KEY_DISABLED);
        }
        this.publishRefreshIhsStateRequestEvent();
    }

    protected void publishRefreshIhsStateRequestEvent() {
        this.eventPublisher.publish((Object)new RefreshIhsStateRequestEvent());
    }

    private Optional<Boolean> getExplicitStateOfFeatureFlag(String featureFlagDisabledKey, String featureFlagEnabledKey) {
        Set featureKeys = this.darkFeatureManager.getFeaturesEnabledForAllUsers().getFeatureKeySet();
        if (featureKeys.contains(featureFlagDisabledKey)) {
            return Optional.of(Boolean.FALSE);
        }
        if (featureKeys.contains(featureFlagEnabledKey)) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    protected abstract boolean isSendingEnabledByDefault();

    protected abstract boolean isFeatureEnabledByDefault();

    protected abstract boolean isRfuMetricsCollectionEnabledByDefault();
}

