/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.feature;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.troubleshooting.api.ClusterMessagingService;
import com.atlassian.troubleshooting.dcdp.feature.RefreshIhsStateRequestEvent;
import com.atlassian.troubleshooting.dcdp.job.DcdpDataCollectionJob;
import com.atlassian.troubleshooting.dcdp.job.DcdpTransferJob;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DcdpTransferFeatureStateListener
implements LifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(DcdpTransferFeatureStateListener.class);
    private final EventPublisher eventPublisher;
    private final DcdpTransferJob dcdpTransferJob;
    private final DcdpDataCollectionJob dcdpDataCollectionJob;
    private final ClusterMessagingService clusterMessagingService;

    @Autowired
    public DcdpTransferFeatureStateListener(EventPublisher eventPublisher, DcdpTransferJob dcdpTransferJob, ClusterMessagingService clusterMessagingService, DcdpDataCollectionJob dcdpDataCollectionJob) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.dcdpTransferJob = Objects.requireNonNull(dcdpTransferJob);
        this.clusterMessagingService = Objects.requireNonNull(clusterMessagingService);
        this.dcdpDataCollectionJob = Objects.requireNonNull(dcdpDataCollectionJob);
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
    }

    public void onStop() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onRefreshIhsStateRequestEvent(RefreshIhsStateRequestEvent ignored) {
        this.dcdpTransferJob.refreshState();
        this.dcdpDataCollectionJob.refreshState();
        this.clusterMessagingService.sendMessage("ihs_refresh", "true");
        LOG.info("Refreshed IHS state and sent message to the cluster");
    }
}

