/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.feature;

import com.atlassian.troubleshooting.analytic.DailyAnalyticsEventSupplier;
import com.atlassian.troubleshooting.dcdp.BatchSentCounter;
import com.atlassian.troubleshooting.dcdp.DcdpTransferService;
import com.atlassian.troubleshooting.dcdp.feature.DcdpTransferFeatureManager;
import com.atlassian.troubleshooting.dcdp.feature.IhsAnalyticEvent;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.DcdpTransferStatus;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class IhsDailyAnalyticsEventSupplier
implements DailyAnalyticsEventSupplier {
    private final DcdpTransferService dcdpTransferService;
    private final BatchSentCounter batchSentCounter;
    private final DcdpTransferFeatureManager dcdpTransferFeatureManager;

    public IhsDailyAnalyticsEventSupplier(DcdpTransferService dcdpTransferService, BatchSentCounter batchSentCounter, DcdpTransferFeatureManager dcdpTransferFeatureManager) {
        this.dcdpTransferService = Objects.requireNonNull(dcdpTransferService);
        this.batchSentCounter = batchSentCounter;
        this.dcdpTransferFeatureManager = dcdpTransferFeatureManager;
    }

    @Override
    public List<Object> getDailyAnalyticEvents() {
        DcdpTransferStatus status = this.dcdpTransferService.status(false);
        return Arrays.asList(new IhsAnalyticEvent(!this.dcdpTransferFeatureManager.isIhsFeatureDisabled(), this.dcdpTransferFeatureManager.isIhsSendDataFeatureEnabled(), status.areComponentsPresent(), status.isConnectionConfigured(), this.batchSentCounter.getAndResetBatchSentCounter(), this.batchSentCounter.getAndResetBatchErrorsCounter()));
    }
}

