/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.job;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.troubleshooting.dcdp.feature.DcdpFeatureFlags;
import com.atlassian.troubleshooting.dcdp.feature.DcdpTransferFeatureManager;
import com.atlassian.troubleshooting.stp.scheduler.SchedulerServiceProvider;
import java.time.Clock;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDcdpJob
implements LifecycleAware,
JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDcdpJob.class);
    final DcdpTransferFeatureManager featureManager;
    final Clock clock;
    private final SchedulerServiceProvider schedulerServiceProvider;

    AbstractDcdpJob(SchedulerServiceProvider schedulerServiceProvider, DcdpTransferFeatureManager featureManager, Clock clock) {
        this.schedulerServiceProvider = schedulerServiceProvider;
        this.featureManager = featureManager;
        this.clock = clock;
    }

    public void onStart() {
        DcdpFeatureFlags ihsFeatureFlags = this.featureManager.getIhsFeatureFlags();
        if (!ihsFeatureFlags.shouldSendData()) {
            LOG.info("Skipping enabling {} Job because of {}", (Object)this.getJobRunnerKey(), (Object)ihsFeatureFlags);
            return;
        }
        SchedulerService schedulerService = this.schedulerServiceProvider.getSchedulerService();
        schedulerService.registerJobRunner(this.getJobRunnerKey(), (JobRunner)this);
        try {
            schedulerService.scheduleJob(JobId.of((String)this.getJobRunnerKey().toString()), JobConfig.forJobRunnerKey((JobRunnerKey)this.getJobRunnerKey()).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)this.getIntervalInMs(), (Date)Date.from(this.clock.instant().plusMillis(this.getIntervalInMs())))));
            LOG.info("Scheduled Job {} every {} ms", (Object)this.getJobRunnerKey(), (Object)this.getIntervalInMs());
        }
        catch (SchedulerServiceException e) {
            LOG.error("Failed to schedule Job {} every {} ms", new Object[]{this.getJobRunnerKey(), this.getIntervalInMs(), e});
        }
    }

    public void onStop() {
        DcdpFeatureFlags ihsFeatureFlags = this.featureManager.getIhsFeatureFlags();
        if (ihsFeatureFlags.shouldSendData()) {
            LOG.info("Skipping disabling {} Job because of {}", (Object)this.getJobRunnerKey(), (Object)ihsFeatureFlags);
            return;
        }
        SchedulerService schedulerService = this.schedulerServiceProvider.getSchedulerService();
        schedulerService.unscheduleJob(JobId.of((String)this.getJobRunnerKey().toString()));
        schedulerService.unregisterJobRunner(this.getJobRunnerKey());
        LOG.info("Stopped Job {}", (Object)this.getJobRunnerKey());
    }

    public void refreshState() {
        LOG.info("Refreshing state of {} job", (Object)this.getJobRunnerKey());
        boolean isJobRegistered = this.schedulerServiceProvider.getSchedulerService().getJobDetails(JobId.of((String)this.getJobRunnerKey().toString())) != null;
        DcdpFeatureFlags ihsFeatureFlags = this.featureManager.getIhsFeatureFlags();
        boolean shouldJobBeRunning = ihsFeatureFlags.shouldSendData();
        if (shouldJobBeRunning && !isJobRegistered) {
            this.onStart();
        } else if (!shouldJobBeRunning && isJobRegistered) {
            this.onStop();
        } else {
            LOG.info("Job {} is already in the desired state, isJobRegistered={}, shouldJobBeRunning={}, ihsFeatureFlags={}", new Object[]{this.getJobRunnerKey(), isJobRegistered, shouldJobBeRunning, ihsFeatureFlags});
        }
    }

    abstract JobRunnerKey getJobRunnerKey();

    abstract long getIntervalInMs();
}

