/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.job;

import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.troubleshooting.dcdp.feature.DcdpTransferFeatureManager;
import com.atlassian.troubleshooting.dcdp.job.AbstractDcdpJob;
import com.atlassian.troubleshooting.dcdp.transfer.data.collector.DcdpDataCollector;
import com.atlassian.troubleshooting.stp.scheduler.SchedulerServiceProvider;
import com.atlassian.troubleshooting.util.ClockFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcdpDataCollectionJob
extends AbstractDcdpJob {
    @VisibleForTesting
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"DcdpDataCollectionJob");
    private static final Logger LOG = LoggerFactory.getLogger(DcdpDataCollectionJob.class);
    private static final long INTERVAL = Long.getLong("atlassian.dcdp.data.collect.scheduler.interval-ms", TimeUnit.MINUTES.toMillis(2L));
    private final DcdpDataCollector dcdpDataCollector;

    public DcdpDataCollectionJob(SchedulerServiceProvider schedulerService, DcdpTransferFeatureManager featureManager, DcdpDataCollector dcdpDataCollector, ClockFactory clockFactory) {
        super(schedulerService, featureManager, clockFactory.makeClock());
        this.dcdpDataCollector = dcdpDataCollector;
    }

    @Override
    JobRunnerKey getJobRunnerKey() {
        return JOB_RUNNER_KEY;
    }

    @Override
    long getIntervalInMs() {
        return INTERVAL;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (!this.featureManager.isEnabled()) {
            return JobRunnerResponse.aborted((String)"Feature is disabled.");
        }
        try {
            this.dcdpDataCollector.collectMultiplePerBatchData();
            LOG.info("Data collected successfully.");
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            LOG.error("Failed to collect data.", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    public static long getInterval() {
        return INTERVAL;
    }
}

