/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.job;

import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.troubleshooting.dcdp.BatchSentCounter;
import com.atlassian.troubleshooting.dcdp.DcdpTransferService;
import com.atlassian.troubleshooting.dcdp.feature.DcdpTransferFeatureManager;
import com.atlassian.troubleshooting.dcdp.job.AbstractDcdpJob;
import com.atlassian.troubleshooting.dcdp.pluginsettings.DcdpPluginSettingsService;
import com.atlassian.troubleshooting.dcdp.transfer.DcdpDataSender;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.DcdpTransferStatus;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.DcdpTransferSubmission;
import com.atlassian.troubleshooting.stp.scheduler.SchedulerServiceProvider;
import com.atlassian.troubleshooting.util.ClockFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DcdpTransferJob
extends AbstractDcdpJob {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"DcdpTransferJob");
    private static final Logger LOG = LoggerFactory.getLogger(DcdpTransferJob.class);
    private static final long INTERVAL = Long.getLong("atlassian.dcdp.transfer.scheduler.interval-ms", TimeUnit.HOURS.toMillis(1L));
    private static final String JOB_FAILED_MESSAGE = "Failed to send diagnostics data to the cloud.";
    private static final String JOB_SKIPPED_CCC_NOT_INSTALLED = "Instance optimization is disabled because of missing Cloud companion app.";
    private static final String JOB_SKIPPED_CONNECTION_NOT_CONFIGURED = "Instance optimization is disabled because of connection is not configured.";
    private static final String JIRA_DC_IO_DOCS = "https://confluence.atlassian.com/x/6iG6W";
    private static final String SPACE = " ";
    private final DcdpDataSender dcdpDataSender;
    private final DcdpTransferService dcdpTransferService;
    private final BatchSentCounter batchSentCounter;
    private final DcdpPluginSettingsService dcdpPluginSettingsService;

    @Autowired
    public DcdpTransferJob(SchedulerServiceProvider schedulerService, DcdpDataSender dcdpDataSender, DcdpTransferFeatureManager featureManager, DcdpTransferService dcdpTransferService, BatchSentCounter batchSentCounter, ClockFactory clockFactory, DcdpPluginSettingsService dcdpPluginSettingsService) {
        super(schedulerService, featureManager, clockFactory.makeClock());
        this.dcdpDataSender = dcdpDataSender;
        this.batchSentCounter = batchSentCounter;
        this.dcdpTransferService = dcdpTransferService;
        this.dcdpPluginSettingsService = dcdpPluginSettingsService;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (!this.featureManager.isEnabled()) {
            return JobRunnerResponse.aborted((String)"Feature is disabled.");
        }
        DcdpTransferStatus status = this.dcdpTransferService.status(false);
        if (!status.areComponentsPresent()) {
            LOG.debug(JOB_SKIPPED_CCC_NOT_INSTALLED);
            return JobRunnerResponse.success((String)"Instance optimization is disabled because of missing Cloud companion app. https://confluence.atlassian.com/x/6iG6W");
        }
        if (!status.isConnectionConfigured()) {
            LOG.debug(JOB_SKIPPED_CONNECTION_NOT_CONFIGURED);
            return JobRunnerResponse.success((String)"Instance optimization is disabled because of connection is not configured. https://confluence.atlassian.com/x/6iG6W");
        }
        try {
            DcdpTransferSubmission result = this.dcdpDataSender.sendDiagnosticsData();
            if (result.succeeded()) {
                this.batchSentCounter.incrementBatchSentCounter();
                LOG.info("Diagnostics data sent successfully.");
                this.dcdpPluginSettingsService.setLastSuccessfulRun(this.clock.instant(), this.getJobRunnerKey());
                return JobRunnerResponse.success();
            }
            this.batchSentCounter.incrementBatchErrorsCounter();
            LOG.error("Failed to send diagnostics data to the cloud. {}", (Object)result.getMessages());
            return JobRunnerResponse.failed((String)JOB_FAILED_MESSAGE);
        }
        catch (Exception e) {
            LOG.error(JOB_FAILED_MESSAGE, (Throwable)e);
            this.batchSentCounter.incrementBatchErrorsCounter();
            return JobRunnerResponse.failed((String)JOB_FAILED_MESSAGE);
        }
    }

    @Override
    JobRunnerKey getJobRunnerKey() {
        return JOB_RUNNER_KEY;
    }

    @Override
    long getIntervalInMs() {
        return INTERVAL;
    }

    public static long getInterval() {
        return INTERVAL;
    }
}

