/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.pluginsettings;

import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcdpPluginSettingsService {
    @VisibleForTesting
    protected static final String DCDP_TRANSFER_LAST_SUCCESSFUL_RUN_KEY_FORMAT = "atst.dcdp:last.success.run.%s";
    private static final Logger LOG = LoggerFactory.getLogger(DcdpPluginSettingsService.class);
    private final PluginSettingsFactory pluginSettingsFactory;

    public DcdpPluginSettingsService(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public Optional<Instant> getLastSuccessfulRun(JobRunnerKey jobRunnerKey) {
        try {
            return Optional.ofNullable(this.pluginSettingsFactory.createGlobalSettings().get(this.getLastSuccessfulRunKey(jobRunnerKey))).map(String.class::cast).map(Long::valueOf).map(Instant::ofEpochMilli);
        }
        catch (NumberFormatException e) {
            LOG.error("Could not parse last successful run timestamp", (Throwable)e);
            return Optional.empty();
        }
    }

    public void setLastSuccessfulRun(Instant lastSuccessfulRunInstant, JobRunnerKey jobRunnerKey) {
        this.pluginSettingsFactory.createGlobalSettings().put(this.getLastSuccessfulRunKey(jobRunnerKey), (Object)String.valueOf(lastSuccessfulRunInstant.toEpochMilli()));
    }

    private String getLastSuccessfulRunKey(JobRunnerKey jobRunnerKey) {
        return String.format(DCDP_TRANSFER_LAST_SUCCESSFUL_RUN_KEY_FORMAT, jobRunnerKey.toString());
    }
}

