/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer;

import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import com.atlassian.plugins.cloud.connect.companion.client.IncompatibleServiceException;
import com.atlassian.troubleshooting.dcdp.DcdpTransferService;
import com.atlassian.troubleshooting.dcdp.transfer.data.DcdpDataHandler;
import com.atlassian.troubleshooting.dcdp.transfer.model.HealthUpdate;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.DcdpTransferSubmission;
import com.atlassian.troubleshooting.stp.audit.Auditor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DcdpDataSender {
    private final DcdpTransferService defaultDiagnosticsPublishingService;
    private final DcdpDataHandler dcdpDataHandler;
    private final Auditor auditor;

    @Autowired
    public DcdpDataSender(DcdpDataHandler dcdpDataHandler, DcdpTransferService defaultDiagnosticsPublishingService, Auditor auditor) {
        this.dcdpDataHandler = dcdpDataHandler;
        this.defaultDiagnosticsPublishingService = defaultDiagnosticsPublishingService;
        this.auditor = auditor;
    }

    public DcdpTransferSubmission sendDiagnosticsData() throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        return this.sendDiagnosticsData(true);
    }

    public DcdpTransferSubmission sendDiagnosticsData(boolean trace) throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        List<HealthUpdate> analyticUpdate = this.dcdpDataHandler.getDiagnosticsData();
        DcdpTransferSubmission dcdpTransferSubmission = this.sendHealthScoreInputMetrics(analyticUpdate, trace);
        if (dcdpTransferSubmission.succeeded()) {
            this.dcdpDataHandler.clearCollectedData();
            this.auditSuccess(analyticUpdate);
        } else {
            this.auditSubmissionError(dcdpTransferSubmission);
        }
        return dcdpTransferSubmission;
    }

    private DcdpTransferSubmission sendHealthScoreInputMetrics(List<HealthUpdate> analyticUpdate, boolean trace) throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        try {
            return this.defaultDiagnosticsPublishingService.sendAnalyticData(analyticUpdate, trace);
        }
        catch (CloudRequestServiceNotAvailableException | IncompatibleServiceException | RuntimeException e) {
            this.auditException(e);
            throw e;
        }
    }

    private void auditSubmissionError(DcdpTransferSubmission dcdpTransferSubmission) {
        this.auditor.audit("stp.ihs.data.sent.error", (Map<String, String>)ImmutableMap.of((Object)"stp.ihs.data.sent.error.submission.status.code", (Object)String.valueOf(dcdpTransferSubmission.getSubmissionStatusCode())), Collections.emptyList());
    }

    private void auditSuccess(List<HealthUpdate> analyticUpdate) {
        long numberOfSamples = this.getNumberOfSamples(analyticUpdate);
        this.auditor.audit("stp.ihs.data.sent.success", (Map<String, String>)ImmutableMap.of((Object)"stp.ihs.data.sent.success.number.of.samples", (Object)String.valueOf(numberOfSamples)), Collections.emptyList());
    }

    @VisibleForTesting
    void auditException(Exception exception) {
        String exceptionMessage = exception.getMessage() != null ? exception.getMessage() : "";
        this.auditor.audit("stp.ihs.data.sent.error", (Map<String, String>)ImmutableMap.of((Object)"stp.ihs.data.sent.error.exception.class", (Object)exception.getClass().getName(), (Object)"stp.ihs.data.sent.error.exception.message", (Object)exceptionMessage), Collections.emptyList());
    }

    @VisibleForTesting
    long getNumberOfSamples(List<HealthUpdate> healthUpdates) {
        return healthUpdates.stream().flatMap(healthUpdate -> healthUpdate.healthIndicatorsByName().values().stream()).mapToLong(List::size).sum();
    }
}

