/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer;

import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.troubleshooting.stp.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class DcdpTransferObjectMapper
implements CloudObjectMapper {
    private final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

    public DcdpTransferObjectMapper() {
        SimpleModule stringParserModule = new SimpleModule("String parser");
        stringParserModule.addDeserializer(String.class, (JsonDeserializer)new StringDeserializer());
        this.objectMapper.registerModules(new Module[]{stringParserModule});
    }

    @Override
    public <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
        if (valueType == String.class) {
            return (T)new String(src);
        }
        return (T)this.objectMapper.readValue(src, valueType);
    }

    @Override
    public byte[] writeValueAsBytes(Object value) throws IOException {
        return this.objectMapper.writeValueAsBytes(value);
    }
}

