/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer;

import com.atlassian.plugins.cloud.connect.companion.client.CloudContext;
import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequest;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestMethod;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceLocator;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import com.atlassian.plugins.cloud.connect.companion.client.CloudResponse;
import com.atlassian.plugins.cloud.connect.companion.client.DataSharingLevel;
import com.atlassian.plugins.cloud.connect.companion.client.IncompatibleServiceException;
import com.atlassian.troubleshooting.dcdp.DcdpTransferService;
import com.atlassian.troubleshooting.dcdp.config.DcdpTransferConfig;
import com.atlassian.troubleshooting.dcdp.transfer.model.HealthUpdate;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.AbstractSubmissionResult;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.DcdpTransferStatus;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.DcdpTransferSubmission;
import com.atlassian.troubleshooting.dcdp.transfer.model.rest.DcdpTransferPayload;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DefaultDcdpTransferService
implements DcdpTransferService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDcdpTransferService.class);
    private final CloudRequestServiceLocator cloudRequestService;
    private final CloudObjectMapper cloudObjectMapper;
    private final DcdpTransferConfig publishingConfig;

    public DefaultDcdpTransferService(CloudRequestServiceLocator cloudRequestService, CloudObjectMapper cloudObjectMapper, DcdpTransferConfig dcdpTransferConfig) {
        this.cloudRequestService = cloudRequestService;
        this.cloudObjectMapper = cloudObjectMapper;
        this.publishingConfig = dcdpTransferConfig;
    }

    @Override
    public DcdpTransferStatus status(boolean trace) {
        DcdpTransferStatus status = new DcdpTransferStatus();
        boolean cloudConnectComponentsPresent = this.cloudRequestService.isPresent();
        if (!cloudConnectComponentsPresent) {
            return status;
        }
        status.setComponentsArePresent(true);
        try {
            CloudResponse<String> dcdpHeartbeatResponse = this.getHeartbeat();
            if (trace) {
                this.recordTraceId(this.getTraceId(dcdpHeartbeatResponse), status);
            }
            if (dcdpHeartbeatResponse.getStatusCode() != HttpStatus.OK.value()) {
                status.setHeartbeatUp(false);
                return status;
            }
        }
        catch (Exception e) {
            status.addMessage(e.getMessage());
            return status;
        }
        status.setConnectionConfigured(true);
        return status;
    }

    @Override
    public DcdpTransferSubmission sendAnalyticData(List<HealthUpdate> healthUpdate, boolean trace) throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        Optional<URL> dcdpPublicUrl = this.publishingConfig.getDcdpPublicUrl("/analytics");
        if (dcdpPublicUrl.isEmpty()) {
            DcdpTransferSubmission results = new DcdpTransferSubmission(healthUpdate, HttpStatus.INTERNAL_SERVER_ERROR.value());
            results.addMessage("Error creating the URL to call DCDP");
            return results;
        }
        CloudRequest<List<HealthUpdate>> cloudRequest = CloudRequest.builder(healthUpdate).method(CloudRequestMethod.POST).url(dcdpPublicUrl.get()).cloudContext(CloudContext.withMinimumDataSharingLevel(DataSharingLevel.LIMITED)).header("Content-Type", "application/json").build();
        CloudResponse<DcdpTransferPayload> cloudResponse = this.cloudRequestService.sendRequest(cloudRequest, DcdpTransferPayload.class, this.cloudObjectMapper);
        LOG.debug("DiagnosticsPipePublishingService.sendAnalyticData() response: [statusCode: {}, body: {}]", (Object)cloudResponse.getStatusCode(), (Object)cloudResponse.getBody());
        DcdpTransferSubmission results = new DcdpTransferSubmission(healthUpdate, cloudResponse.getStatusCode());
        List<String> errorMessages = this.getErrorResponse(cloudResponse, HttpStatus.NO_CONTENT.value(), false);
        if (!errorMessages.isEmpty()) {
            errorMessages.forEach(results::addMessage);
        }
        if (trace) {
            this.recordTraceId(this.getTraceId(cloudResponse), results);
        }
        return results;
    }

    private void recordTraceId(String traceId, AbstractSubmissionResult result) {
        result.addMessage(String.format("%s: %s", "X-Trace-Id", traceId));
    }

    private String getTraceId(CloudResponse<?> cloudResponse) {
        List<String> traceHeaders = cloudResponse.getHeaders().get("X-Trace-Id");
        if (traceHeaders == null || traceHeaders.isEmpty()) {
            return "undefined";
        }
        return traceHeaders.get(0);
    }

    private CloudResponse<String> getHeartbeat() throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        Optional<URL> dcdpHeartbeatUrl = this.publishingConfig.getDcdpPublicUrl("/heartbeat");
        if (dcdpHeartbeatUrl.isEmpty()) {
            throw new IllegalArgumentException("Error creating the URL to call DCDP");
        }
        CloudRequest cloudRequest = CloudRequest.builder().method(CloudRequestMethod.GET).url(dcdpHeartbeatUrl.get()).cloudContext(CloudContext.withMinimumDataSharingLevel(DataSharingLevel.LIMITED)).build();
        return this.cloudRequestService.sendRequest(cloudRequest, String.class, this.cloudObjectMapper);
    }

    private List<String> getErrorResponse(CloudResponse<?> cloudResponse, int requiredStatusCode, boolean payloadRequired) {
        ArrayList<String> messages = new ArrayList<String>();
        if (cloudResponse.getStatusCode() != requiredStatusCode) {
            messages.add("Invalid response code from server: " + cloudResponse.getStatusCode() + ", expected " + requiredStatusCode);
        }
        Object responsePayload = cloudResponse.getBody();
        if (payloadRequired && responsePayload == null) {
            messages.add("Invalid response code from server: " + cloudResponse.getStatusCode() + ", expected " + requiredStatusCode);
            messages.add("Response Payload: empty");
        }
        return messages;
    }
}

