/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer.data;

import com.atlassian.sal.api.UrlMode;
import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.dcdp.transfer.data.collector.DcdpDataCollector;
import com.atlassian.troubleshooting.dcdp.transfer.model.HealthUpdate;
import com.atlassian.troubleshooting.dcdp.transfer.model.ProductInfo;
import com.atlassian.troubleshooting.dcdp.utils.HashCalculator;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.util.ClockFactory;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DcdpDataHandler {
    private final ClusterService clusterService;
    private final SupportApplicationInfo supportApplicationInfo;
    private final Clock clock;
    private final DcdpDataCollector dcdpDataCollector;
    private final HashCalculator hashCalculator;

    @Autowired
    public DcdpDataHandler(ClusterService clusterService, SupportApplicationInfo supportApplicationInfo, ClockFactory clockFactory, DcdpDataCollector dcdpDataCollector, HashCalculator hashCalculator) {
        this.clusterService = clusterService;
        this.supportApplicationInfo = supportApplicationInfo;
        this.clock = clockFactory.makeClock();
        this.dcdpDataCollector = dcdpDataCollector;
        this.hashCalculator = hashCalculator;
    }

    public List<HealthUpdate> getDiagnosticsData() {
        ProductInfo productInfo = new ProductInfo(this.getHashNodeId(), this.supportApplicationInfo.getApplicationSEN(), this.supportApplicationInfo.getApplicationName(), this.supportApplicationInfo.getApplicationVersion(), this.supportApplicationInfo.getBaseURL(UrlMode.ABSOLUTE));
        this.dcdpDataCollector.collectSinglePerBatchData();
        return Collections.singletonList(new HealthUpdate(productInfo, this.clock.millis(), this.dcdpDataCollector.getCollectedData()));
    }

    public Map<String, String> getAllHashNodeIds() {
        Set<String> nodeIds = this.clusterService.getNodeIds();
        if (nodeIds.isEmpty()) {
            return Collections.singletonMap("mainNode", this.hashCalculator.calculateHash("mainNode"));
        }
        return this.clusterService.getNodeIds().stream().collect(Collectors.toMap(nodeId -> nodeId, this.hashCalculator::calculateHash));
    }

    String getHashNodeId() {
        return this.hashCalculator.calculateHash(this.clusterService.getCurrentNodeId().orElse("mainNode"));
    }

    public void clearCollectedData() {
        this.dcdpDataCollector.clearCollectedData();
    }
}

