/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer.data.collector;

import com.atlassian.troubleshooting.dcdp.transfer.data.retriever.DcdpDataRetriever;
import com.atlassian.troubleshooting.dcdp.transfer.model.HealthIndicator;
import com.atlassian.troubleshooting.util.ClockFactory;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DcdpDataCollector {
    @VisibleForTesting
    static final long MAX_METRIC_LIST_SIZE = 750L;
    private final ConcurrentMap<String, List<HealthIndicator>> healthIndicatorsByName;
    private final List<DcdpDataRetriever> dataRetrievers;
    private final Clock clock;

    @Autowired
    public DcdpDataCollector(List<DcdpDataRetriever> dataRetrievers, ClockFactory clockFactory) {
        this.dataRetrievers = dataRetrievers;
        this.clock = clockFactory.makeClock();
        this.healthIndicatorsByName = new ConcurrentHashMap<String, List<HealthIndicator>>();
    }

    @VisibleForTesting
    DcdpDataCollector(List<DcdpDataRetriever> dataRetrievers, ClockFactory clockFactory, ConcurrentMap<String, List<HealthIndicator>> healthIndicatorsByName) {
        this.dataRetrievers = dataRetrievers;
        this.clock = clockFactory.makeClock();
        this.healthIndicatorsByName = healthIndicatorsByName;
    }

    public void collectMultiplePerBatchData() {
        this.collectData(this.dataRetrievers.stream().filter(dataRetriever -> !dataRetriever.isSinglePerBatch()).toList());
    }

    public void collectSinglePerBatchData() {
        this.collectData(this.dataRetrievers.stream().filter(DcdpDataRetriever::isSinglePerBatch).toList());
    }

    private void collectData(List<DcdpDataRetriever> dataRetrievers) {
        long collectionTimestamp = this.clock.millis();
        dataRetrievers.forEach(dataRetriever -> dataRetriever.retrieveMetrics(collectionTimestamp).forEach(this::addHealthIndicator));
    }

    public Map<String, List<HealthIndicator>> getCollectedData() {
        return this.healthIndicatorsByName;
    }

    public void clearCollectedData() {
        this.healthIndicatorsByName.clear();
    }

    private synchronized void addHealthIndicator(HealthIndicator healthIndicator) {
        List healthIndicators;
        if (!this.healthIndicatorsByName.containsKey(healthIndicator.metricName())) {
            healthIndicators = new LinkedList<HealthIndicator>();
        } else {
            healthIndicators = (List)this.healthIndicatorsByName.get(healthIndicator.metricName());
            if ((long)healthIndicators.size() >= 750L) {
                healthIndicators.remove(0);
            }
        }
        healthIndicators.add(healthIndicator);
        this.healthIndicatorsByName.put(healthIndicator.metricName(), healthIndicators);
    }
}

