/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer.data.retriever;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.troubleshooting.dcdp.transfer.data.retriever.DcdpDataRetriever;
import com.atlassian.troubleshooting.dcdp.transfer.data.retriever.model.JmxQuery;
import com.atlassian.troubleshooting.dcdp.transfer.model.HealthIndicator;
import com.atlassian.troubleshooting.dcdp.utils.HashCalculator;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDcdpJmxDataRetriever
implements DcdpDataRetriever {
    private static final Double VALUE_ZERO = 0.0;
    private static final Double VALUE_ONE = 1.0;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDcdpJmxDataRetriever.class);
    private static final String JMX_METRIC_QUERIES_DIR = "transfer.data.query";
    private final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
    private final List<JmxQuery> jmxQueryList;
    private final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final HashCalculator hashCalculator;

    public AbstractDcdpJmxDataRetriever(HashCalculator hashCalculator, SupportApplicationInfo supportApplicationInfo) {
        this.hashCalculator = hashCalculator;
        this.jmxQueryList = this.loadQueriesFromFile(supportApplicationInfo.getApplicationName());
    }

    abstract String getQueriesFileName();

    @Override
    public List<HealthIndicator> retrieveMetrics(long collectionTimestamp) {
        ArrayList<HealthIndicator> healthIndicators = new ArrayList<HealthIndicator>();
        for (JmxQuery jmxQuery : this.getJmxQueryList()) {
            try {
                Set<ObjectName> objectNames = this.platformMBeanServer.queryNames(new ObjectName(jmxQuery.getObjectNameQuery()), null);
                objectNames.forEach(objectName -> {
                    if (this.shouldFilterOut((ObjectName)objectName, jmxQuery)) {
                        return;
                    }
                    String metricName = this.getMetricName((ObjectName)objectName, jmxQuery);
                    HashMap<String, Object> attributes = new HashMap<String, Object>(this.retrieveAttributesForMetric(jmxQuery, (ObjectName)objectName));
                    if (attributes.isEmpty()) {
                        LOG.debug("No attributes found for object: {}", objectName);
                        return;
                    }
                    HashMap<String, String> tags = new HashMap<String, String>(this.retrieveTagsForMetric(jmxQuery, (ObjectName)objectName));
                    healthIndicators.add(new HealthIndicator(metricName, attributes, tags, HealthIndicator.Type.JMX_METRIC, collectionTimestamp));
                });
            }
            catch (MalformedObjectNameException e) {
                LOG.error("Malformed object name: {}", (Object)jmxQuery.getObjectNameQuery(), (Object)e);
            }
        }
        return healthIndicators;
    }

    @VisibleForTesting
    Map<String, Object> retrieveAttributesForMetric(JmxQuery jmxQuery, ObjectName objectName) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        jmxQuery.getAttributes().forEach(attribute -> {
            try {
                Number numberValue;
                Object attributeValue = this.platformMBeanServer.getAttribute(objectName, (String)attribute);
                if ("NaN".equals(attributeValue)) {
                    LOG.debug("Attribute {} has value NaN for object: {}", attribute, (Object)objectName);
                    return;
                }
                if (jmxQuery.isFilterValuesLessThanZero() && attributeValue instanceof Number && (numberValue = (Number)attributeValue).doubleValue() < 0.0) {
                    LOG.debug("Attribute {} has value less than zero for object: {}", attribute, (Object)objectName);
                    return;
                }
                if (attributeValue instanceof Boolean) {
                    Boolean booleanValue = (Boolean)attributeValue;
                    attributes.put((String)attribute, booleanValue != false ? VALUE_ONE : VALUE_ZERO);
                } else {
                    attributes.put((String)attribute, attributeValue);
                }
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                LOG.error("Error reading attribute: {} from object: {}", new Object[]{attribute, objectName, e});
            }
        });
        return attributes;
    }

    private Map<String, String> retrieveTagsForMetric(JmxQuery jmxQuery, ObjectName objectName) {
        HashMap<String, String> tags = new HashMap<String, String>();
        jmxQuery.getTags().forEach(tag -> {
            String tagValue = objectName.getKeyProperty(String.format("tag.%s", tag));
            if (tagValue == null) {
                LOG.error("Tag {} not found in object name: {}", tag, (Object)objectName);
                return;
            }
            if (jmxQuery.getTagsToHash().contains(tag)) {
                tags.put((String)tag, this.hashCalculator.calculateHash(tagValue));
            } else {
                tags.put((String)tag, tagValue);
            }
        });
        return tags;
    }

    private boolean shouldFilterOut(ObjectName objectName, JmxQuery jmxQuery) {
        return this.getFilters().stream().anyMatch(filter -> filter.test(objectName, jmxQuery));
    }

    abstract String getMetricName(ObjectName var1, JmxQuery var2);

    List<BiPredicate<ObjectName, JmxQuery>> getFilters() {
        return Collections.emptyList();
    }

    protected List<JmxQuery> getJmxQueryList() {
        return this.jmxQueryList;
    }

    private List<JmxQuery> loadQueriesFromFile(String applicationName) {
        String jmxMetricsQueriesFilePath = String.format("%s/%s-%s", JMX_METRIC_QUERIES_DIR, applicationName.toLowerCase(), this.getQueriesFileName());
        InputStream jmxMetricQueriesAsStream = ClassLoaderUtils.getResourceAsStream((String)jmxMetricsQueriesFilePath, this.getClass());
        if (jmxMetricQueriesAsStream == null) {
            LOG.error("Failed to load JMX metric queries from file: {}", (Object)jmxMetricsQueriesFilePath);
            return Collections.emptyList();
        }
        try {
            return Arrays.asList((JmxQuery[])this.objectMapper.readValue(jmxMetricQueriesAsStream, JmxQuery[].class));
        }
        catch (IOException e) {
            LOG.error("Failed to map JMX metric queries from stream: {}", (Object)jmxMetricsQueriesFilePath);
            return Collections.emptyList();
        }
    }
}

