/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer.data.retriever;

import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.dcdp.transfer.data.provider.GuardrailsProductDataProvider;
import com.atlassian.troubleshooting.dcdp.transfer.data.retriever.DcdpDataRetriever;
import com.atlassian.troubleshooting.dcdp.transfer.model.HealthIndicator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DcdpGuardrailsRetriever
implements DcdpDataRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(DcdpGuardrailsRetriever.class);
    private static final String NODE_COUNT_METRIC_NAME = "node.count";
    private static final String VALUE_ATTRIBUTE_NAME = "Value";
    private final GuardrailsProductDataProvider guardrailsDataProvider;
    private final ClusterService clusterService;

    public DcdpGuardrailsRetriever(GuardrailsProductDataProvider guardrailsDataProvider, ClusterService clusterService) {
        this.guardrailsDataProvider = guardrailsDataProvider;
        this.clusterService = clusterService;
    }

    @Override
    public List<HealthIndicator> retrieveMetrics(long collectionTimestamp) {
        ArrayList<HealthIndicator> healthIndicators = new ArrayList<HealthIndicator>();
        this.guardrailsDataProvider.getGuardrailsData().forEach((key, value) -> healthIndicators.add(this.createHealthIndicator(this.transformKeyToMetricName((String)key), (String)value, collectionTimestamp)));
        healthIndicators.add(this.createHealthIndicator(this.transformKeyToMetricName(NODE_COUNT_METRIC_NAME), String.valueOf(this.clusterService.getNodeCount().orElse(1)), collectionTimestamp));
        LOG.debug("Retrieved health indicators: {}", healthIndicators);
        return healthIndicators;
    }

    private HealthIndicator createHealthIndicator(String guardrailName, String guardrailValue, long collectionTimestamp) {
        HealthIndicator healthIndicator = new HealthIndicator(guardrailName, HealthIndicator.Type.GUARDRAILS, collectionTimestamp);
        healthIndicator.addAttribute(VALUE_ATTRIBUTE_NAME, guardrailValue);
        return healthIndicator;
    }

    private String transformKeyToMetricName(String key) {
        return String.format("guardrails.%s", key.toLowerCase().replace(" ", ".").replace("_", ".").replace("-", "."));
    }

    @Override
    public DcdpDataRetriever.CollectingType getCollectingType() {
        return DcdpDataRetriever.CollectingType.SINGLE_PER_BATCH;
    }
}

