/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer.data.retriever;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.troubleshooting.dcdp.job.DcdpDataCollectionJob;
import com.atlassian.troubleshooting.dcdp.transfer.data.retriever.AbstractDcdpJmxDataRetriever;
import com.atlassian.troubleshooting.dcdp.transfer.data.retriever.model.JmxQuery;
import com.atlassian.troubleshooting.dcdp.utils.HashCalculator;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.util.ClockFactory;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DcdpIpdDataRetriever
extends AbstractDcdpJmxDataRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(DcdpIpdDataRetriever.class);
    private final CrowdDirectoryService crowdDirectoryService;
    private long lastCollectionTimestamp = 0L;
    private Optional<String> cachedExternalUserDirTopPriorityName = Optional.empty();
    private final Clock clock;

    @Autowired
    public DcdpIpdDataRetriever(CrowdDirectoryService crowdDirectoryService, ClockFactory clockFactory, HashCalculator hashCalculator, SupportApplicationInfo supportApplicationInfo) {
        super(hashCalculator, supportApplicationInfo);
        this.crowdDirectoryService = crowdDirectoryService;
        this.clock = clockFactory.makeClock();
    }

    @Override
    protected String getQueriesFileName() {
        return "ipdMetricQueries.json";
    }

    @Override
    String getMetricName(ObjectName objectName, JmxQuery jmxQuery) {
        return jmxQuery.getObjectName() != null ? jmxQuery.getObjectName() : this.objectNameKeysToMetricName(objectName);
    }

    private String objectNameKeysToMetricName(ObjectName objectName) {
        return objectName.getKeyPropertyList().keySet().stream().filter(key -> key.contains("category")).sorted().map(objectName::getKeyProperty).collect(Collectors.joining("."));
    }

    @Override
    List<BiPredicate<ObjectName, JmxQuery>> getFilters() {
        return Collections.singletonList(this.filterOutNonTopExtUserDir());
    }

    @VisibleForTesting
    BiPredicate<ObjectName, JmxQuery> filterOutNonTopExtUserDir() {
        return (objectName, jmxQuery) -> {
            if (!this.objectNameKeysToMetricName((ObjectName)objectName).contains("user.directory")) {
                return false;
            }
            Optional<String> topPriorityUserDirectoryNameFromCrowdService = this.getExternalUserDirTopPriorityName();
            String userDirectoryNameFromTag = objectName.getKeyProperty("tag.userDirName");
            if (!topPriorityUserDirectoryNameFromCrowdService.isPresent() || !this.isTheSameUserDirectory(userDirectoryNameFromTag, topPriorityUserDirectoryNameFromCrowdService.get())) {
                LOG.debug("Filtering out non-top external user directory: {}, topPriorityUserDirectoryNameFromCrowdService={}", (Object)objectName.getCanonicalName(), topPriorityUserDirectoryNameFromCrowdService);
                return true;
            }
            return false;
        };
    }

    private boolean isTheSameUserDirectory(String userDirectoryNameFromTag, String userDirectoryNameFromExternalUserDir) {
        return userDirectoryNameFromTag.equals(userDirectoryNameFromExternalUserDir.replace(" ", "_"));
    }

    private Optional<String> getExternalUserDirTopPriorityName() {
        long currentTime = this.clock.millis();
        if (this.lastCollectionTimestamp == 0L || !this.cachedExternalUserDirTopPriorityName.isPresent() || currentTime - this.lastCollectionTimestamp > DcdpDataCollectionJob.getInterval()) {
            this.lastCollectionTimestamp = currentTime;
            this.cachedExternalUserDirTopPriorityName = this.findExternalUserDirTopPriorityName();
        }
        return this.cachedExternalUserDirTopPriorityName;
    }

    @NotNull
    private Optional<String> findExternalUserDirTopPriorityName() {
        return this.crowdDirectoryService.findAllDirectories().stream().filter(directory -> directory.getType() != DirectoryType.INTERNAL).findFirst().map(Directory::getName);
    }
}

