/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer.data.retriever;

import com.atlassian.troubleshooting.dcdp.transfer.data.retriever.AbstractDcdpJmxDataRetriever;
import com.atlassian.troubleshooting.dcdp.transfer.data.retriever.model.JmxQuery;
import com.atlassian.troubleshooting.dcdp.utils.HashCalculator;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DcdpPerfRetriever
extends AbstractDcdpJmxDataRetriever {
    @VisibleForTesting
    static final Set<String> YOUNG_GC_NAMES = ImmutableSet.of((Object)"ParNew", (Object)"PS Scavenge", (Object)"G1 Young Generation");
    @VisibleForTesting
    static final Set<String> OLD_GC_NAMES = ImmutableSet.of((Object)"ConcurrentMarkSweep", (Object)"PS MarkSweep", (Object)"G1 Old Generation");
    @VisibleForTesting
    static final Set<String> SUPPORTED_GC_NAMES = Stream.concat(YOUNG_GC_NAMES.stream(), OLD_GC_NAMES.stream()).collect(Collectors.toSet());
    private static final Logger LOG = LoggerFactory.getLogger(DcdpPerfRetriever.class);

    @Autowired
    public DcdpPerfRetriever(HashCalculator hashCalculator, SupportApplicationInfo supportApplicationInfo) {
        super(hashCalculator, supportApplicationInfo);
    }

    @Override
    String getQueriesFileName() {
        return "perfMetricQueries.json";
    }

    @Override
    String getMetricName(ObjectName objectName, JmxQuery jmxQuery) {
        if (jmxQuery.getObjectName() == null) {
            return objectName.getKeyPropertyList().keySet().stream().sorted().map(objectName::getKeyProperty).collect(Collectors.joining("."));
        }
        if (jmxQuery.getObjectNameQuery().contains("GarbageCollector")) {
            return this.getGcMetricName(objectName, jmxQuery);
        }
        return jmxQuery.getObjectName();
    }

    private String getGcMetricName(ObjectName objectName, JmxQuery jmxQuery) {
        if (YOUNG_GC_NAMES.stream().anyMatch(objectName.getKeyProperty("name")::contains)) {
            return String.format("%s.%s", jmxQuery.getObjectName(), "young");
        }
        if (OLD_GC_NAMES.stream().anyMatch(objectName.getKeyProperty("name")::contains)) {
            return String.format("%s.%s", jmxQuery.getObjectName(), "old");
        }
        return jmxQuery.getObjectName();
    }

    @Override
    List<BiPredicate<ObjectName, JmxQuery>> getFilters() {
        return Collections.singletonList(this.filterOutNotSupportedGcMetrics());
    }

    private BiPredicate<ObjectName, JmxQuery> filterOutNotSupportedGcMetrics() {
        return (objectName, jmxQuery) -> {
            if (jmxQuery.getObjectNameQuery().contains("GarbageCollector")) {
                if (SUPPORTED_GC_NAMES.stream().noneMatch(objectName.getKeyProperty("name")::contains)) {
                    LOG.debug("Filtering out unsupported GC metric: {}", (Object)objectName.getCanonicalName());
                    return true;
                }
            }
            return false;
        };
    }
}

