/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.transfer.model.internal;

import com.atlassian.troubleshooting.dcdp.transfer.model.HealthUpdate;
import com.atlassian.troubleshooting.dcdp.transfer.model.internal.AbstractSubmissionResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class DcdpTransferSubmission
extends AbstractSubmissionResult {
    @JsonProperty
    private boolean success = false;
    @JsonProperty
    private int submissionStatusCode = 0;
    @JsonProperty
    private final List<HealthUpdate> payload;

    public DcdpTransferSubmission(List<HealthUpdate> payload, int submissionStatusCode) {
        this.payload = payload;
        this.submissionStatusCode = submissionStatusCode;
        this.success = submissionStatusCode / 100 == 2;
    }

    public boolean succeeded() {
        return this.success;
    }

    @Override
    public String getMessages() {
        if (!this.succeeded()) {
            this.messages.add("DiagnosticsPipe Submission failed");
        } else {
            this.messages.add("DiagnosticsPipe Submission succeeded");
        }
        return this.messages.toString();
    }

    public void setSucceeded(boolean success) {
        this.success = success;
    }

    public int getSubmissionStatusCode() {
        return this.submissionStatusCode;
    }

    public List<HealthUpdate> getPayload() {
        return this.payload;
    }
}

