/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;

@Service
public class HashCalculator {
    private static final int MAX_CACHE_SIZE = 128;
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

    public String calculateHash(String input) {
        if (this.cache.size() > 128) {
            this.clearCache();
        }
        return this.cache.computeIfAbsent(input, this::calculateHashInternal);
    }

    String calculateHashInternal(String input) {
        return DigestUtils.sha256Hex((String)input);
    }

    void clearCache() {
        this.cache.clear();
    }
}

