/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.dcdp.utils;

import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.troubleshooting.dcdp.pluginsettings.DcdpPluginSettingsService;
import com.atlassian.troubleshooting.util.ClockFactory;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class SchedulerDatesService {
    @VisibleForTesting
    static final DateTimeFormatter DEFAULT_OUTPUT_FORMATTER = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm z");
    private final SchedulerService schedulerService;
    private final DcdpPluginSettingsService dcdpPluginSettingsService;
    private final TimeZoneManager timeZoneManager;
    private final Clock clock;

    @Autowired
    public SchedulerDatesService(SchedulerService schedulerService, DcdpPluginSettingsService dcdpPluginSettingsService, TimeZoneManager timeZoneManager, ClockFactory clockFactory) {
        this.schedulerService = schedulerService;
        this.dcdpPluginSettingsService = dcdpPluginSettingsService;
        this.timeZoneManager = timeZoneManager;
        this.clock = clockFactory.makeClock();
    }

    public Optional<String> getNextRunDateForJobKey(JobRunnerKey jobRunnerKey) {
        JobId jobId = JobId.of((String)jobRunnerKey.toString());
        JobDetails jobDetails = this.schedulerService.getJobDetails(jobId);
        Optional<Instant> lastRunDetails = this.dcdpPluginSettingsService.getLastSuccessfulRun(jobRunnerKey);
        if (jobDetails == null) {
            return Optional.empty();
        }
        if (!lastRunDetails.isPresent()) {
            return this.getFirstRunDate(jobDetails).map(this::formatDate);
        }
        Date nextRunDate = jobDetails.getNextRunTime();
        Optional<Long> intervalInMs = this.getIntervalInMs(jobDetails);
        if (nextRunDate != null && nextRunDate.after(Date.from(this.clock.instant()))) {
            return Optional.of(this.formatDate(nextRunDate));
        }
        if (intervalInMs.isPresent()) {
            Instant lastRunStartDate = lastRunDetails.get();
            return Optional.of(this.formatDate(Date.from(lastRunStartDate.plusMillis(intervalInMs.get()))));
        }
        return Optional.empty();
    }

    private String formatDate(Date date) {
        return this.formatDate(date.toInstant());
    }

    private String formatDate(Instant instant) {
        return ZonedDateTime.ofInstant(instant, this.timeZoneManager.getUserTimeZone().toZoneId()).format(DEFAULT_OUTPUT_FORMATTER);
    }

    private Optional<Date> getFirstRunDate(JobDetails jobDetails) {
        Schedule schedule = jobDetails.getSchedule();
        if (schedule.getType().equals((Object)Schedule.Type.INTERVAL)) {
            return Optional.ofNullable(schedule.getIntervalScheduleInfo().getFirstRunTime());
        }
        return Optional.empty();
    }

    private Optional<Long> getIntervalInMs(JobDetails jobDetails) {
        Schedule schedule = jobDetails.getSchedule();
        if (schedule.getType().equals((Object)Schedule.Type.INTERVAL)) {
            return Optional.of(schedule.getIntervalScheduleInfo().getIntervalInMillis());
        }
        return Optional.empty();
    }

    public Optional<String> getLastSuccessfulRunDateForJobKey(JobRunnerKey jobRunnerKey) {
        Optional<Instant> lastSuccessfulRunDetails = this.dcdpPluginSettingsService.getLastSuccessfulRun(jobRunnerKey);
        if (lastSuccessfulRunDetails.isPresent()) {
            Instant lastUpload = lastSuccessfulRunDetails.get();
            return Optional.of(this.formatDate(lastUpload));
        }
        return Optional.empty();
    }
}

