/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.auth;

import com.atlassian.plugins.authentication.api.config.BasicAuthService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import java.io.Serializable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicAuthDisabledHealthCheck
implements SupportHealthCheck {
    private final SupportHealthStatusBuilder healthStatusBuilder;
    private final BundleContext bundleContext;

    @Autowired
    public BasicAuthDisabledHealthCheck(SupportHealthStatusBuilder healthStatusBuilder, BundleContext bundleContext) {
        this.healthStatusBuilder = healthStatusBuilder;
        this.bundleContext = bundleContext;
    }

    @Override
    public SupportHealthStatus check() {
        try (BasicAuthServiceWrapper basicAuthServiceWrapper = new BasicAuthServiceWrapper();){
            if (basicAuthServiceWrapper.getBasicAuthServiceReference() == null) {
                SupportHealthStatus supportHealthStatus = this.healthStatusBuilder.ok(this, "healthcheck.basic.authentication.unavailable", new Serializable[0]);
                return supportHealthStatus;
            }
            BasicAuthService basicAuthService = basicAuthServiceWrapper.getBasicAuthService();
            if (basicAuthService.isDisabled()) {
                SupportHealthStatus supportHealthStatus = this.healthStatusBuilder.ok(this, "healthcheck.basic.authentication.disabled", new Serializable[0]);
                return supportHealthStatus;
            }
            SupportHealthStatus supportHealthStatus = this.healthStatusBuilder.warning(this, "healthcheck.basic.authentication.enabled", new Serializable[0]);
            return supportHealthStatus;
        }
    }

    private final class BasicAuthServiceWrapper
    implements AutoCloseable {
        private final ServiceReference<?> basicAuthServiceReference;

        private BasicAuthServiceWrapper() {
            this.basicAuthServiceReference = BasicAuthDisabledHealthCheck.this.bundleContext.getServiceReference("com.atlassian.plugins.authentication.api.config.BasicAuthService");
        }

        @Override
        public void close() {
            if (this.basicAuthServiceReference != null) {
                BasicAuthDisabledHealthCheck.this.bundleContext.ungetService(this.basicAuthServiceReference);
            }
        }

        private ServiceReference<?> getBasicAuthServiceReference() {
            return this.basicAuthServiceReference;
        }

        private BasicAuthService getBasicAuthService() {
            return (BasicAuthService)BasicAuthDisabledHealthCheck.this.bundleContext.getService(this.basicAuthServiceReference);
        }
    }
}

