/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.clientcredentials;

import com.atlassian.crowd.embedded.api.OAuth2Method;
import com.atlassian.crowd.embedded.api.authentication.AuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthService;
import com.atlassian.crowd.model.service.ServiceAccountAuthMethodImpl;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientExpirationEvaluator;
import com.atlassian.troubleshooting.healthcheck.checks.clientcredentials.ClientService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceAccountClientService
extends ClientService {
    private final ServiceAccountAuthService serviceAccountAuthService;

    @Autowired
    public ServiceAccountClientService(ServiceAccountAuthService serviceAccountAuthService, ClientExpirationEvaluator clientExpirationEvaluator) {
        super(clientExpirationEvaluator);
        this.serviceAccountAuthService = serviceAccountAuthService;
    }

    public Set<String> getServiceAccountsClientIds(List<Client> clientList) {
        return clientList.stream().filter(this::isServiceAccountClient).map(Client::getId).collect(Collectors.toSet());
    }

    private boolean isServiceAccountClient(Client client) {
        return this.serviceAccountAuthService.findByAuthMethod((ServiceAccountAuthMethod)new ServiceAccountAuthMethodImpl(client.getId(), (AuthMethod)new OAuth2Method())).isPresent();
    }
}

