/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.clientcredentials;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.external.OAuth2ProviderService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.clientcredentials.ServiceAccountClientService;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceAccountsCredentialsExpirationHealthCheck
implements SupportHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAccountsCredentialsExpirationHealthCheck.class);
    private final SupportHealthStatusBuilder healthStatusBuilder;
    private final OAuth2ProviderService oAuth2ProviderService;
    private final ActiveObjects activeObjects;
    private final ServiceAccountClientService serviceAccountClientService;

    @Autowired
    public ServiceAccountsCredentialsExpirationHealthCheck(SupportHealthStatusBuilder healthStatusBuilder, OAuth2ProviderService oAuth2ProviderService, ActiveObjects activeObjects, ServiceAccountClientService serviceAccountClientService) {
        this.healthStatusBuilder = healthStatusBuilder;
        this.oAuth2ProviderService = oAuth2ProviderService;
        this.activeObjects = activeObjects;
        this.serviceAccountClientService = serviceAccountClientService;
    }

    @Override
    public SupportHealthStatus check() {
        return (SupportHealthStatus)this.activeObjects.executeInTransaction(() -> {
            LOG.debug("Checking Service Accounts client credentials expiration");
            List clientList = this.oAuth2ProviderService.listClients();
            Set<String> serviceAccountsClientIds = this.serviceAccountClientService.getServiceAccountsClientIds(clientList);
            long totalServiceAccountClients = this.serviceAccountClientService.getTotalClientsCount(clientList, serviceAccountsClientIds);
            Set<Client> expiredServiceAccountsClients = this.serviceAccountClientService.getExpiredClients(clientList, serviceAccountsClientIds);
            long expiredServiceAccountClients = expiredServiceAccountsClients.size();
            long soonToExpireServiceAccountClients = this.serviceAccountClientService.getSoonToExpireClientsCount(clientList, serviceAccountsClientIds, expiredServiceAccountsClients);
            if (expiredServiceAccountClients > 0L && soonToExpireServiceAccountClients > 0L) {
                return this.healthStatusBuilder.major(this, "healthcheck.service.accounts.client.credentials.check.expired.and.soon.to.expire", Long.valueOf(expiredServiceAccountClients), Long.valueOf(totalServiceAccountClients), Long.valueOf(soonToExpireServiceAccountClients));
            }
            if (expiredServiceAccountClients > 0L) {
                return this.healthStatusBuilder.major(this, "healthcheck.service.accounts.client.credentials.check.expired", Long.valueOf(expiredServiceAccountClients), Long.valueOf(totalServiceAccountClients));
            }
            if (soonToExpireServiceAccountClients > 0L) {
                return this.healthStatusBuilder.warning(this, "healthcheck.service.accounts.client.credentials.check.soon.to.expire", Long.valueOf(soonToExpireServiceAccountClients), Long.valueOf(totalServiceAccountClients));
            }
            return this.healthStatusBuilder.ok(this, "healthcheck.service.accounts.client.credentials.check.valid", new Serializable[0]);
        });
    }
}

