/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.datacenter.database.clustered.aws.aurora;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.troubleshooting.api.healthcheck.Application;
import com.atlassian.troubleshooting.api.healthcheck.DatabaseService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.DefaultSupportHealthCheckSupplier;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AmazonAuroraDCOnlyCheck
implements SupportHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSupportHealthCheckSupplier.class);
    private static final String CONFLUENCE_MIN_SUPPORTED_VERSION = "Confluence Data Center 6.13";
    private static final String JIRA_MIN_SUPPORTED_VERSION = "Jira Data Center 8.4";
    private static final String HEALTH_CHECK_PREFIX = "healthcheck.datacenter.database.clustered";
    private static final String AURORA_VERSION_QUERY = "select AURORA_VERSION() as aurora_version";
    private static final String SUPPORTED_DIALECT = "postgres";
    private static final String ENGINE_IDENTIFIER = "aws.aurora";
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;
    private final DatabaseService databaseService;
    private final ApplicationProperties properties;

    @Autowired
    public AmazonAuroraDCOnlyCheck(DatabaseService databaseService, ApplicationProperties properties, SupportHealthStatusBuilder supportHealthStatusBuilder) {
        this.properties = Objects.requireNonNull(properties);
        this.supportHealthStatusBuilder = Objects.requireNonNull(supportHealthStatusBuilder);
        this.databaseService = Objects.requireNonNull(databaseService);
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    public SupportHealthStatus check() {
        if (this.databaseService.runInConnection(this::isRunningOn).booleanValue()) {
            if (this.databaseService.getDialect().toLowerCase().contains(SUPPORTED_DIALECT.toLowerCase())) {
                return this.supportHealthStatusBuilder.warning(this, this.buildKey(true), new Serializable[]{this.getResponseSubstitutionForProduct()});
            }
            return this.supportHealthStatusBuilder.ok(this, this.buildKey(false), new Serializable[0]);
        }
        return this.supportHealthStatusBuilder.ok(this, this.buildKey(false), new Serializable[0]);
    }

    private String getResponseSubstitutionForProduct() {
        Application application = Application.byAppDisplayName(this.properties.getDisplayName());
        switch (application) {
            case Confluence: {
                return CONFLUENCE_MIN_SUPPORTED_VERSION;
            }
            case JIRA: {
                return JIRA_MIN_SUPPORTED_VERSION;
            }
        }
        throw new UnsupportedOperationException(String.format("%s Is not supported with product: %s", new Object[]{this.getClass().getCanonicalName(), application}));
    }

    private String buildKey(boolean inUse) {
        return inUse ? String.format("%s.%s.supported.false", HEALTH_CHECK_PREFIX, ENGINE_IDENTIFIER) : String.format("%s.unused", HEALTH_CHECK_PREFIX);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isRunningOn(Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(AURORA_VERSION_QUERY);){
            boolean bl;
            block14: {
                ResultSet resultSet = statement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException sqle) {
            LOG.debug(String.format("Clustered database health check did not detect Aurora database: %s", sqle.getMessage()), (Throwable)sqle);
            return false;
        }
    }
}

