/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.mailqueue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.mailqueue.MailQueueObserver;
import com.atlassian.troubleshooting.healthcheck.checks.mailqueue.analytics.MailQueueStuckEvent;
import java.io.Serializable;
import java.util.Optional;

public class MailQueueHealthCheck
implements SupportHealthCheck {
    private final MailQueueObserver mailQueueObserver;
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;
    private final ClusterService clusterService;
    private final EventPublisher eventPublisher;

    public MailQueueHealthCheck(ClusterService clusterService, SupportHealthStatusBuilder supportHealthStatusBuilder, MailQueueObserver mailQueueObserver, EventPublisher eventPublisher) {
        this.supportHealthStatusBuilder = supportHealthStatusBuilder;
        this.mailQueueObserver = mailQueueObserver;
        this.clusterService = clusterService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public boolean isNodeSpecific() {
        return true;
    }

    @Override
    public SupportHealthStatus check() {
        return this.checkLastMailAge().orElseGet(this::healthyStatus);
    }

    private Optional<SupportHealthStatus> checkLastMailAge() {
        if (!this.mailQueueObserver.isOldestEmailAboveTimeThreshold()) {
            return Optional.empty();
        }
        this.eventPublisher.publish((Object)new MailQueueStuckEvent(this.mailQueueObserver.getMailQueueSize(), this.mailQueueObserver.isMailQueueSending()));
        return Optional.of(this.supportHealthStatusBuilder.warning(this, this.getI18nClusterFlavorMessage("healthcheck.mail.queue.failed"), Integer.valueOf(this.mailQueueObserver.getAllowedMinutesToStay())));
    }

    private SupportHealthStatus healthyStatus() {
        return this.supportHealthStatusBuilder.ok(this, this.getI18nClusterFlavorMessage("healthcheck.mail.queue.healthy"), new Serializable[0]);
    }

    private String getI18nClusterFlavorMessage(String i18nKey) {
        return this.clusterService.isClustered() ? i18nKey + ".dc" : i18nKey + ".server";
    }
}

