/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.mailqueue.config;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailQueueHealthCheckProperties {
    private static final int DEFAULT_MAIL_QUEUE_THRESHOLD_MINUTES = 30;
    private static final String MAIL_QUEUE_STAY_THRESHOLD_MINUTES = "mail.healthcheck.threshold.minutes";
    private static final Logger LOGGER = LoggerFactory.getLogger(MailQueueHealthCheckProperties.class);
    private final Supplier<Integer> mailQueueThresholdMinutes = Suppliers.memoize(() -> {
        try {
            return Integer.parseInt(System.getProperty(MAIL_QUEUE_STAY_THRESHOLD_MINUTES, String.valueOf(30)));
        }
        catch (NumberFormatException e) {
            LOGGER.warn(String.format("Failed to format '%s', using default value instead: %s.", MAIL_QUEUE_STAY_THRESHOLD_MINUTES, 30), (Throwable)e);
            return 30;
        }
    });

    public int getMailQueueStayThresholdMinutes() {
        return this.mailQueueThresholdMinutes.get();
    }
}

