/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.vuln;

import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.troubleshooting.healthcheck.checks.vuln.CveValidator;
import com.atlassian.troubleshooting.stp.hercules.regex.cacheables.SavedExternalResource;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public enum CveExternalResource implements SavedExternalResource
{
    BAMBOO_CVES("bamboo"),
    BITBUCKET_CVES("bitbucket"),
    CONFLUENCE_CVES("confluence"),
    CROWD("crowd"),
    JIRA_CVES("jira"),
    JSD_CVES("jsd");

    private final URL cachedUrl;
    private final String localFilename;

    private CveExternalResource(String product) {
        String atstUrl = System.getProperty("atst.data.url", "https://atst-data.atl-paas.net");
        try {
            this.cachedUrl = new URL(String.format("%s/healthcheck/cve/%s.json", atstUrl, product));
            this.localFilename = String.format("healthcheck-cve-%s.json", product);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public URL getCachedUrl() {
        return this.cachedUrl;
    }

    @Override
    public String getLocalFilename() {
        return this.localFilename;
    }

    @Override
    public String parseResponse(HttpResponse response) throws ResponseException {
        try {
            String contents = EntityUtils.toString((HttpEntity)response.getEntity());
            CveValidator.parseJson(contents);
            return contents;
        }
        catch (IOException | RuntimeException e) {
            throw new ResponseException("CVE Data was not in the expected format", (Throwable)e);
        }
    }
}

