/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.rest;

import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.troubleshooting.healthcheck.model.InvalidLicenseUserLimitException;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.service.LicenseUserLimitService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@WebSudoRequired
public abstract class AbstractLicenseUserLimitResource {
    private final LicenseUserLimitService licenseUserLimitService;

    protected AbstractLicenseUserLimitResource(LicenseUserLimitService licenseUserLimitService) {
        this.licenseUserLimitService = licenseUserLimitService;
    }

    @Path(value="/config")
    @GET
    public Response getLicenseUserLimitConfig() {
        return Response.ok((Object)this.licenseUserLimitService.getLicenseUserLimitConfig()).build();
    }

    @Path(value="/config")
    @PUT
    public Response setLicenseUserLimitConfig(LicenseUserLimitConfiguration licenseUserLimitConfiguration) {
        try {
            this.licenseUserLimitService.setLicenseUserLimitConfig(licenseUserLimitConfiguration);
        }
        catch (InvalidLicenseUserLimitException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return Response.ok((Object)licenseUserLimitConfiguration).build();
    }

    @Path(value="/license-details")
    @GET
    public Response getLicenseDetails() {
        return this.licenseUserLimitService.getLicenseDetails().map(Response::ok).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }
}

