/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.api.HealthCheckUserSettingsService;
import com.atlassian.troubleshooting.healthcheck.api.model.HealthCheckUserSettings;
import com.atlassian.troubleshooting.healthcheck.persistence.service.HealthCheckWatcherService;
import com.atlassian.troubleshooting.healthcheck.util.SupportHealthCheckUtils;
import com.atlassian.troubleshooting.stp.salext.ApplicationType;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

@ExperimentalApi
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@SystemAdminOnly
@Path(value="/user-setting/{username}")
public class HealthCheckUserSettingsResource {
    private final HealthCheckUserSettingsService userSettingsService;
    private final UserManager userManager;
    private final HealthCheckWatcherService watcherService;
    private final SupportApplicationInfo applicationInfo;

    @Inject
    public HealthCheckUserSettingsResource(HealthCheckUserSettingsService userSettingsService, UserManager userManager, HealthCheckWatcherService watcherService, SupportApplicationInfo applicationInfo) {
        this.userSettingsService = userSettingsService;
        this.userManager = userManager;
        this.watcherService = watcherService;
        this.applicationInfo = applicationInfo;
    }

    @GET
    public HealthCheckUserSettings getUserSettings(@PathParam(value="username") String username) {
        UserKey userKey = this.getUserKey(username);
        return this.getUserSettings(userKey);
    }

    @GET
    @WebSudoRequired
    @Path(value="/notification-severity")
    public SupportHealthStatus.Severity getSeverityThresholdForNotifications(@PathParam(value="username") String username) {
        return this.getUserSettings(username).getSeverityThresholdForNotifications();
    }

    @PUT
    @WebSudoRequired
    @Path(value="/notification-severity")
    public SupportHealthStatus.Severity setSeverityThresholdForNotifications(@PathParam(value="username") String username, SupportHealthStatus.Severity severity) {
        UserKey userKey = this.getUserKey(username);
        this.userSettingsService.setSeverityForNotification(userKey, severity);
        return this.getUserSettings(userKey).getSeverityThresholdForNotifications();
    }

    @PUT
    @WebSudoRequired
    @Path(value="watch")
    public void watch(@PathParam(value="username") String username) {
        this.checkSupportsEmailNotifications();
        this.watcherService.watch(this.getUserKey(username));
    }

    @DELETE
    @WebSudoRequired
    @Path(value="watch")
    public void unwatch(@PathParam(value="username") String username) {
        this.checkSupportsEmailNotifications();
        this.watcherService.unwatch(this.getUserKey(username));
    }

    private HealthCheckUserSettings getUserSettings(UserKey userKey) {
        return this.userSettingsService.getUserSettings(userKey);
    }

    private UserKey getUserKey(String username) {
        return SupportHealthCheckUtils.getUserKey(this.userManager, username);
    }

    private void checkSupportsEmailNotifications() {
        if (this.applicationInfo.getApplicationType() == ApplicationType.BITBUCKET || this.applicationInfo.getApplicationType() == ApplicationType.CROWD) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)(this.applicationInfo.getApplicationName() + " does not currently support email notifications")).type("text/plain").build());
        }
    }
}

