/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.scheduler;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.troubleshooting.api.PluginInfo;
import com.atlassian.troubleshooting.api.healthcheck.HealthCheckStatus;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheckManager;
import com.atlassian.troubleshooting.healthcheck.event.HealthcheckScheduledFinishedEvent;
import com.atlassian.troubleshooting.healthcheck.persistence.service.HealthStatusPersistenceService;
import com.atlassian.troubleshooting.healthcheck.persistence.service.NotificationService;
import com.atlassian.troubleshooting.healthcheck.scheduler.HealthCheckScheduler;
import com.atlassian.troubleshooting.stp.scheduler.SchedulerServiceProvider;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HealthCheckSchedulerImpl
implements HealthCheckScheduler,
LifecycleAware,
JobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckSchedulerImpl.class);
    private static final String JOB_NAME = "ATSTHealthCheckJob";
    private static final long INTERVAL = Long.getLong("atlassian.healthcheck.scheduler.interval-ms", TimeUnit.HOURS.toMillis(1L));
    private static final JobId JOB_ID = JobId.of((String)"ATSTHealthCheckJob:job");
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"ATSTHealthCheckJob:jobRunner");
    private final HealthStatusPersistenceService healthStatusPersistenceService;
    private final NotificationService notificationService;
    private final SupportHealthCheckManager healthCheckService;
    private final EventPublisher eventPublisher;
    private final PluginInfo pluginInfo;
    private final SchedulerServiceProvider schedulerServiceProvider;

    @Autowired
    public HealthCheckSchedulerImpl(SchedulerServiceProvider schedulerServiceProvider, HealthStatusPersistenceService healthStatusPersistenceService, NotificationService notificationService, SupportHealthCheckManager healthCheckService, EventPublisher eventPublisher, PluginInfo pluginInfo) {
        this.healthStatusPersistenceService = healthStatusPersistenceService;
        this.notificationService = notificationService;
        this.healthCheckService = healthCheckService;
        this.eventPublisher = eventPublisher;
        this.pluginInfo = pluginInfo;
        this.schedulerServiceProvider = Objects.requireNonNull(schedulerServiceProvider);
    }

    @Override
    public void schedule() {
        Schedule schedule = Schedule.forInterval((long)INTERVAL, (Date)new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L)));
        try {
            this.schedulerServiceProvider.getSchedulerService().scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(schedule));
        }
        catch (SchedulerServiceException e) {
            LOGGER.error("Failed to schedule Healthcheck Jobs", (Throwable)e);
        }
        LOGGER.debug("Scheduled Healthcheck Job running every {}ms", (Object)INTERVAL);
    }

    public void onStart() {
        try {
            LOGGER.debug("Removing the old job if applicable...");
            this.schedulerServiceProvider.getSchedulerService().unregisterJobRunner(JOB_RUNNER_KEY);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Attempting to remove the previous job failed - likely because it did not exist previously. This should be safe to ignore");
        }
        this.schedulerServiceProvider.getSchedulerService().registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedule();
    }

    public void onStop() {
        LOGGER.debug("Removing the old job on plugin stop");
        this.schedulerServiceProvider.getSchedulerService().unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @ParametersAreNonnullByDefault
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        LOGGER.debug("Performing a scheduled HealthCheck of the instance. Brace yourselves.");
        for (HealthCheckStatus status : this.healthCheckService.runAllHealthChecks()) {
            this.eventPublisher.publish((Object)new HealthcheckScheduledFinishedEvent(status.getCompleteKey(), status.isHealthy(), status.getFailureReason(), status.getSeverity().ordinal(), this.pluginInfo.getPluginVersion()));
        }
        List<Integer> recordIds = this.healthStatusPersistenceService.deleteFailedStatusRecord();
        if (!recordIds.isEmpty()) {
            this.notificationService.deleteDismissById(recordIds);
        }
        LOGGER.debug("Scheduled HealthCheck complete!");
        return JobRunnerResponse.success();
    }
}

