/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.service;

import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.healthcheck.event.LicenseUserLimitConfigUpdateEvent;
import com.atlassian.troubleshooting.healthcheck.model.InvalidLicenseUserLimitException;
import com.atlassian.troubleshooting.healthcheck.model.LicenseDetails;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitCheckType;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.service.LicenseUserLimitService;
import com.atlassian.troubleshooting.stp.audit.Auditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUserLimitServiceEventProxy
implements LicenseUserLimitService {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseUserLimitServiceEventProxy.class);
    private final Auditor auditor;
    private final LicenseUserLimitService delegate;
    private final EventPublisher eventPublisher;
    private final LicenseUserLimitCheckType checkType;
    private final I18nResolver i18nResolver;

    public LicenseUserLimitServiceEventProxy(LicenseUserLimitService delegate, EventPublisher eventPublisher, LicenseUserLimitCheckType checkType, Auditor auditor, I18nResolver i18nResolver) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.checkType = checkType;
        this.auditor = auditor;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public LicenseUserLimitConfiguration getLicenseUserLimitConfig() {
        return this.delegate.getLicenseUserLimitConfig();
    }

    @Override
    public Optional<LicenseDetails> getLicenseDetails() {
        return this.delegate.getLicenseDetails();
    }

    @Override
    public boolean isConfigurable() {
        return this.delegate.isConfigurable();
    }

    @Override
    public void setLicenseUserLimitConfig(LicenseUserLimitConfiguration licenseUserLimitConfiguration) throws InvalidLicenseUserLimitException {
        Objects.requireNonNull(licenseUserLimitConfiguration, "licenseUserLimitConfiguration cannot be null");
        LicenseUserLimitConfiguration oldConfiguration = this.delegate.getLicenseUserLimitConfig();
        this.delegate.setLicenseUserLimitConfig(licenseUserLimitConfiguration);
        this.sendAuditLog(oldConfiguration, licenseUserLimitConfiguration);
        this.sendAnalyticsEvent(licenseUserLimitConfiguration);
    }

    private void sendAuditLog(LicenseUserLimitConfiguration oldConfiguration, LicenseUserLimitConfiguration newConfiguration) {
        List<ChangedValue> changedValues = this.getChangedValues(oldConfiguration, newConfiguration);
        if (!changedValues.isEmpty()) {
            Map<String, String> unchangedValues = this.getUnchangedValues(oldConfiguration, newConfiguration);
            this.auditor.audit(String.format(this.checkType.getI18nKeyTemplate(), "configuration.changed.audit.summary"), unchangedValues, changedValues);
        }
    }

    private void sendAnalyticsEvent(LicenseUserLimitConfiguration licenseUserLimitConfiguration) {
        LOG.debug("sending analytics event for licenseUserLimitConfiguration update");
        this.eventPublisher.publish((Object)LicenseUserLimitConfigUpdateEvent.of(licenseUserLimitConfiguration, this.checkType));
    }

    private List<ChangedValue> getChangedValues(LicenseUserLimitConfiguration oldConfiguration, LicenseUserLimitConfiguration newConfiguration) {
        ArrayList<ChangedValue> changedValues = new ArrayList<ChangedValue>();
        if (oldConfiguration.getLimit() != newConfiguration.getLimit()) {
            changedValues.add(ChangedValue.fromI18nKeys((String)"stp.license.user.limit.audit.limit.field.name").from(String.valueOf(oldConfiguration.getLimit())).to(String.valueOf(newConfiguration.getLimit())).build());
        }
        if (oldConfiguration.getIsPercentage() != newConfiguration.getIsPercentage()) {
            changedValues.add(ChangedValue.fromI18nKeys((String)"stp.license.user.limit.audit.limit.type.field.name").from(this.translateIsPercentage(oldConfiguration.getIsPercentage())).to(this.translateIsPercentage(newConfiguration.getIsPercentage())).build());
        }
        return changedValues;
    }

    private Map<String, String> getUnchangedValues(LicenseUserLimitConfiguration oldConfiguration, LicenseUserLimitConfiguration newConfiguration) {
        HashMap<String, String> unChangedValues = new HashMap<String, String>();
        if (oldConfiguration.getLimit() == newConfiguration.getLimit()) {
            unChangedValues.put("stp.license.user.limit.audit.limit.field.name", String.valueOf(newConfiguration.getLimit()));
        }
        if (oldConfiguration.getIsPercentage() == newConfiguration.getIsPercentage()) {
            unChangedValues.put("stp.license.user.limit.audit.limit.type.field.name", this.translateIsPercentage(newConfiguration.getIsPercentage()));
        }
        return unChangedValues;
    }

    private String translateIsPercentage(boolean isPercentage) {
        return isPercentage ? this.i18nResolver.getText("stp.license.user.limit.audit.limit.type.percentage") : this.i18nResolver.getText("stp.license.user.limit.audit.limit.type.number");
    }
}

