/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.request;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.MailException;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.spi.HostApplication;
import com.atlassian.troubleshooting.stp.action.DefaultMessage;
import com.atlassian.troubleshooting.stp.events.StpSupportRequestEmailEvent;
import com.atlassian.troubleshooting.stp.request.SupportRequestCreationRequest;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.mail.MailUtility;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequest;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequestAttachment;
import com.atlassian.troubleshooting.stp.task.MonitoredCallable;
import com.atlassian.troubleshooting.stp.task.MutableTaskMonitor;
import com.atlassian.troubleshooting.stp.task.SubtaskMonitorListener;
import com.atlassian.troubleshooting.stp.zip.CreateSupportZipTask;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSupportRequestTask
implements MonitoredCallable<Void, MutableTaskMonitor<Void>> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSupportRequestTask.class);
    private static final int WEIGHT_CREATE_SUPPORT_ZIP = 90;
    private final SupportApplicationInfo applicationInfo;
    private final Optional<CreateSupportZipTask> createZipTask;
    private final HostApplication hostApplication;
    private final MailUtility mailUtility;
    private final MutableTaskMonitor<Void> monitor;
    private final SupportRequestCreationRequest request;
    private final String username;
    private final EventPublisher eventPublisher;
    private final TemplateRenderer templateRenderer;

    CreateSupportRequestTask(SupportRequestCreationRequest request, SupportApplicationInfo applicationInfo, HostApplication hostApplication, MailUtility mailUtility, EventPublisher eventPublisher, MutableTaskMonitor<Void> monitor, @Nullable CreateSupportZipTask createSupportZipTask, @Nullable String username) {
        this.applicationInfo = applicationInfo;
        this.hostApplication = hostApplication;
        this.mailUtility = mailUtility;
        this.request = request;
        this.templateRenderer = applicationInfo.getTemplateRenderer();
        this.username = username;
        this.eventPublisher = eventPublisher;
        this.monitor = monitor;
        this.createZipTask = Optional.ofNullable(createSupportZipTask);
        if (this.createZipTask.isPresent()) {
            createSupportZipTask.getMonitor().addListener(new SubtaskMonitorListener(monitor, 90));
        }
    }

    @Override
    public Void call() throws Exception {
        return this.hostApplication.asUser(this.username, () -> {
            this.createSupportRequest();
            return null;
        }).call();
    }

    protected void createSupportRequest() {
        try {
            SupportRequest supportRequest = new SupportRequest(this.request.getDescription(), this.request.getSubject(), this.applicationInfo.getCreateSupportRequestEmail(), this.request.getFromAddress(), this.generateMailBody(), this.request.getPriority());
            this.monitor.updateProgress(90, this.applicationInfo.getText("stp.create.support.request.inprogress.message"));
            Optional zipFileOptional = this.createZipTask.flatMap(this::safelyCallCreateZipTask);
            if (zipFileOptional.isPresent()) {
                this.addZipAttachment(supportRequest, (File)zipFileOptional.get());
            } else {
                supportRequest.setAttachSupportZipStatus("Customer didn't add the attachment");
            }
            this.mailUtility.sendSupportRequestMail(supportRequest, this.applicationInfo);
            this.monitor.updateProgress(100, this.applicationInfo.getText("stp.create.support.request.success.title"));
        }
        catch (MailException | RenderingException | MessagingException e) {
            this.handleException((Exception)e, "Sending support request", "stp.mail.delivery.error");
        }
        catch (Exception e) {
            this.handleException(e, "General error", "stp.mail.general.error");
        }
    }

    protected void addZipAttachment(SupportRequest supportRequest, File zipFile) {
        try {
            supportRequest.addAttachment(new SupportRequestAttachment(zipFile.getName(), "application/zip", zipFile));
            supportRequest.setAttachSupportZipStatus("Customer successfully added the attachment");
            this.doAnalytics(true);
        }
        catch (Exception e) {
            supportRequest.setAttachSupportZipStatus("Error while adding the attachment");
            LOG.error("Failed to add zip attachment", (Throwable)e);
        }
    }

    private void doAnalytics(boolean successful) {
        Set<String> selectedBundles = this.request.getBundles().stream().map(SupportZipBundle::getKey).collect(Collectors.toSet());
        Integer fileConstraintSize = this.request.getFileConstraintSize();
        Boolean isFileSizeLimited = this.request.isLimitFileSizes();
        Integer fileConstraintLastModified = this.request.getFileConstraintLastModified();
        this.eventPublisher.publish((Object)new StpSupportRequestEmailEvent(successful, selectedBundles, isFileSizeLimited, fileConstraintSize, fileConstraintLastModified));
    }

    @Override
    @Nonnull
    public MutableTaskMonitor<Void> getMonitor() {
        return this.monitor;
    }

    private Optional<File> safelyCallCreateZipTask(CreateSupportZipTask task) {
        try {
            return Optional.ofNullable(task.call());
        }
        catch (Exception e) {
            LOG.error("Failed to create support zip", (Throwable)e);
            return Optional.empty();
        }
    }

    private String generateMailBody() throws RenderingException, IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("description", this.request.getDescription());
        context.put("contactEmail", this.request.getFromAddress());
        context.put("priority", String.valueOf(this.request.getPriority()));
        StringWriter writer = new StringWriter();
        this.templateRenderer.render(this.getTemplateFile(), context, (Writer)writer);
        return writer.toString();
    }

    private void handleException(Exception e, String name, String key) {
        LOG.error(name, (Throwable)e);
        String errorMessage = this.applicationInfo.getText(key);
        this.monitor.updateProgress(100, errorMessage);
        this.monitor.addError(new DefaultMessage(name, errorMessage));
        this.doAnalytics(false);
    }

    private String getTemplateFile() {
        return "/templates/email/create-support-request.vm";
    }
}

