/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.troubleshooting.stp.hercules.LogScanMonitor;
import com.atlassian.troubleshooting.stp.hercules.LogScanService;
import com.atlassian.troubleshooting.stp.rest.CacheControlUtils;
import com.atlassian.troubleshooting.stp.rest.RestLogScanStatus;
import com.atlassian.troubleshooting.stp.scheduler.ScheduledHerculesHealthReportAction;
import com.atlassian.troubleshooting.stp.security.AuthorisationException;
import com.atlassian.troubleshooting.stp.security.PermissionValidationService;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Objects;

@Path(value="hercules")
@Produces(value={"application/json"})
@Singleton
public class HerculesResource {
    private final LogScanService scanService;
    private final ScheduledHerculesHealthReportAction action;
    private final PermissionValidationService permissionValidationService;

    @Inject
    public HerculesResource(@Nonnull LogScanService scanService, @Nonnull ScheduledHerculesHealthReportAction action, @Nonnull PermissionValidationService permissionValidationService) {
        this.scanService = Objects.requireNonNull(scanService);
        this.action = Objects.requireNonNull(action);
        this.permissionValidationService = Objects.requireNonNull(permissionValidationService);
    }

    @GET
    @Path(value="scans/{id}")
    public Response getScanDetails(@PathParam(value="id") String taskId) {
        this.permissionValidationService.validateIsSysadmin();
        LogScanMonitor monitor = this.scanService.getMonitor(taskId);
        if (monitor == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControlUtils.NO_CACHE).build();
        }
        if (monitor.isCancelled()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControlUtils.NO_CACHE).build();
        }
        Response.ResponseBuilder builder = Response.ok().entity((Object)new RestLogScanStatus(monitor));
        if (!monitor.isDone()) {
            builder.cacheControl(CacheControlUtils.NO_CACHE);
        }
        return builder.build();
    }

    @GET
    @Path(value="periodicScanner/settings")
    public Response getPeriodicScannerSettings(@Context HttpServletRequest req) {
        this.permissionValidationService.validateIsSysadmin();
        Map<String, Object> map = this.action.getScannerSettings(req);
        Response.ResponseBuilder builder = Response.ok().entity(map);
        return builder.build();
    }

    @POST
    @Path(value="periodicScanner/settings")
    @XsrfProtectionExcluded
    public Response storePeriodicScannerSettings(@FormParam(value="atl_token") String token, @FormParam(value="enabled") String isEnabled, @FormParam(value="start-time-hour") int startHour, @FormParam(value="start-time-minute") int startMinute, @FormParam(value="frequency") String frequency, @FormParam(value="recipients") String recipients, @Context HttpServletRequest req) {
        try {
            this.permissionValidationService.validateIsSysadmin();
            Map<String, Object> map = this.action.storeScannerSettings(isEnabled, startHour, startMinute, frequency, recipients, token, req);
            Response.ResponseBuilder builder = map.containsKey("errors") || map.containsKey("tokenError") ? Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(map) : Response.ok().entity(map);
            return builder.build();
        }
        catch (AuthorisationException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @ExperimentalApi
    @DELETE
    @Path(value="scans/removeCache")
    @XsrfProtectionExcluded
    public Response clearScanCache() {
        this.scanService.clearScanResultCache();
        return Response.status((Response.Status)Response.Status.OK).cacheControl(CacheControlUtils.NO_CACHE).build();
    }
}

