/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.salext.mail;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.mail.AbstractSupportMailQueueItem;
import com.atlassian.troubleshooting.stp.salext.mail.ProductAwareEmail;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequest;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequestAttachment;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportRequestMailQueueItem
extends AbstractSupportMailQueueItem {
    private static final Logger LOG = LoggerFactory.getLogger(SupportRequestMailQueueItem.class);
    private final String applicationName;
    private final SupportRequest supportRequest;

    public SupportRequestMailQueueItem(SupportRequest supportRequest, SupportApplicationInfo info) {
        this.applicationName = info.getApplicationName();
        this.supportRequest = supportRequest;
    }

    public static Multipart toMultiPart(SupportRequest supportRequest) throws MailException {
        MimeMultipart bodyMimeMultipart = new MimeMultipart();
        try {
            if (supportRequest.getBody() != null) {
                MimeBodyPart textContent = new MimeBodyPart();
                textContent.setText(supportRequest.getBody());
                bodyMimeMultipart.addBodyPart((BodyPart)textContent);
            }
            for (SupportRequestAttachment attachment : supportRequest.getAttachments()) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                Serializable serializable = attachment.getData();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, File.class, String.class}, (Object)serializable, n)) {
                    case 0: {
                        byte[] byteArrayData = (byte[])serializable;
                        ByteArrayDataSource fds = new ByteArrayDataSource(byteArrayData, attachment.getType());
                        attachmentPart.setDataHandler(new DataHandler((DataSource)fds));
                        break;
                    }
                    case 1: {
                        File file = (File)serializable;
                        FileDataSource dataSource = new FileDataSource(file);
                        attachmentPart.setDataHandler(new DataHandler((DataSource)dataSource));
                        break;
                    }
                    case 2: {
                        String text = (String)((Object)serializable);
                        attachmentPart.setText(text);
                        break;
                    }
                    default: {
                        LOG.error("Unrecognized attachment type: {}", (Object)attachment.getData().getClass().getName());
                    }
                }
                attachmentPart.setFileName(attachment.getName());
                LOG.debug("Adding attachment {}", (Object)attachmentPart.getFileName());
                bodyMimeMultipart.addBodyPart((BodyPart)attachmentPart);
            }
        }
        catch (MessagingException e) {
            throw new MailException(e.getMessage(), (Throwable)e);
        }
        return bodyMimeMultipart;
    }

    public SupportRequest getSupportRequest() {
        return this.supportRequest;
    }

    public void send() throws MailException {
        Email email = new ProductAwareEmail(this.supportRequest.getToAddress()).addProductHeader(this.applicationName).setFrom(this.supportRequest.getFromAddress()).setSubject(this.supportRequest.getSubject());
        for (Map.Entry<String, String> entry : this.supportRequest.getHeaders()) {
            email.addHeader(entry.getKey(), entry.getValue());
        }
        Multipart bodyMimeMultipart = SupportRequestMailQueueItem.toMultiPart(this.supportRequest);
        email.setMultipart(bodyMimeMultipart);
        this.send(email);
    }

    public String getSubject() {
        return this.supportRequest.getSubject();
    }
}

