/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.scheduler;

import com.atlassian.scheduler.config.Schedule;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang3.Validate;

public class ScheduleFactory {
    public Schedule createSchedule(long intervalMillis, int startHour, int startMinute) {
        Validate.isTrue((intervalMillis > 0L ? 1 : 0) != 0, (String)"Interval must be positive: %s", (long)intervalMillis);
        Validate.isTrue((startHour >= 0 && startHour <= 23 ? 1 : 0) != 0, (String)"Start hour must be between 0 & 23: %s", (long)startHour);
        Validate.isTrue((startMinute >= 0 && startMinute <= 60 ? 1 : 0) != 0, (String)"Start minute must be between 0 & 60: %s", (long)startMinute);
        LocalDateTime nextExecutionDate = LocalDateTime.now().withHour(startHour).withMinute(startMinute);
        while (nextExecutionDate.isBefore(LocalDateTime.now())) {
            nextExecutionDate = nextExecutionDate.plus(intervalMillis, ChronoUnit.MILLIS);
        }
        return Schedule.forInterval((long)intervalMillis, (Date)Date.from(nextExecutionDate.atZone(ZoneId.systemDefault()).toInstant()));
    }
}

