/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.thready.rest;

import com.atlassian.troubleshooting.stp.security.PermissionValidationService;
import com.atlassian.troubleshooting.thready.manager.ThreadDiagnosticsConfigurationManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;

@Path(value="threadDiagnostics")
@Produces(value={"application/json"})
@Singleton
public class ThreadDiagnosticsResource {
    private final ThreadDiagnosticsConfigurationManager threadDiagnosticsConfigurationManager;
    private final PermissionValidationService permissionValidationService;

    @Inject
    public ThreadDiagnosticsResource(ThreadDiagnosticsConfigurationManager threadDiagnosticsConfigurationManager, PermissionValidationService permissionValidationService) {
        this.threadDiagnosticsConfigurationManager = Objects.requireNonNull(threadDiagnosticsConfigurationManager);
        this.permissionValidationService = Objects.requireNonNull(permissionValidationService);
    }

    @GET
    @Path(value="config")
    public ThreadDiagnosticsConfigurationManager.Configuration configuration() {
        this.permissionValidationService.validateIsSysadmin();
        return this.threadDiagnosticsConfigurationManager.getConfiguration();
    }

    @POST
    @Path(value="config")
    public void setConfig(ThreadDiagnosticsConfigurationManager.Configuration configuration) {
        this.permissionValidationService.validateIsSysadmin();
        this.threadDiagnosticsConfigurationManager.setConfiguration(configuration);
    }
}

