/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.plugin.internal;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.cdn.api.StaticAssetsProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.security.csp.api.CspDirective;
import com.atlassian.security.csp.api.CspFragment;
import com.atlassian.security.csp.api.CspModuleDescriptor;
import com.atlassian.security.csp.api.internal.ContentSecurityPolicy;
import com.atlassian.security.csp.plugin.internal.ContentSecurityPolicyHeaderGenerator;
import com.atlassian.security.csp.spi.CspProvider;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.AntPathMatcher;

public class ContentSecurityPolicyHeaderFilter
implements Filter {
    private static final Pattern NONCE_PATTERN = Pattern.compile("nonce-([a-zA-Z0-9+/=]+)");
    public static final String CSP_NONCE_ID = "cspNonceId";
    public static final String ATLASSIAN_PREFIX_CDN_URL = "atlassian.prefix.cdn.url";
    public static final String ATLASSIAN_CDN_ENABLED = "atlassian.cdn.enabled";
    private final PluginAccessor pluginAccessor;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static Optional<String> reportOnly;
    private final CspProvider policyProvider;
    private final ApplicationProperties applicationProperties;
    private final StaticAssetsProvider staticAssetsProvider;

    public ContentSecurityPolicyHeaderFilter(PluginAccessor pluginAccessor, CspProvider policyProvider, ApplicationProperties applicationProperties, StaticAssetsProvider staticAssetsProvider) {
        this.pluginAccessor = pluginAccessor;
        this.policyProvider = policyProvider;
        this.applicationProperties = applicationProperties;
        this.staticAssetsProvider = staticAssetsProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        reportOnly = Optional.ofNullable(filterConfig.getInitParameter("report-only"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            ContentSecurityPolicy cspPolicy;
            boolean shouldLog = Boolean.getBoolean("enable.csp.violation.logging");
            ContentSecurityPolicy contentSecurityPolicy = cspPolicy = this.policyProvider == null ? null : this.policyProvider.getPolicy();
            if (!shouldLog || cspPolicy == null || cspPolicy.toString() == null || cspPolicy.toString().isEmpty() || this.pluginAccessor == null) {
                return;
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            List exclusionPatterns = this.policyProvider.getExclusionPatterns();
            for (String exclusionPattern : exclusionPatterns) {
                if (!this.antPathMatcher.match(exclusionPattern, httpRequest.getRequestURI())) continue;
                return;
            }
            this.addBaseUrlAndReportURLToCspPolicy(httpRequest, cspPolicy);
            List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CspModuleDescriptor.class);
            List<CspFragment> cspFragments = descriptors.stream().map(ModuleDescriptor::getModule).toList();
            List<CspFragment> matchedCspFragments = cspFragments.stream().filter(fragment -> fragment != null && fragment.getUrlPatterns().stream().anyMatch(urlPattern -> this.antPathMatcher.match(urlPattern, httpRequest.getRequestURI()))).toList();
            matchedCspFragments.forEach(arg_0 -> ((ContentSecurityPolicy)cspPolicy).addCspFragment(arg_0));
            String cspHeaderName = ContentSecurityPolicyHeaderGenerator.generateHeaderName(Boolean.valueOf(reportOnly.orElse("true")));
            String cspHeaderValue = cspPolicy.toString();
            String nonce = this.getNonce(cspHeaderValue);
            if (nonce != null && !nonce.isEmpty()) {
                request.setAttribute(CSP_NONCE_ID, (Object)nonce);
            }
            httpResponse.setHeader(cspHeaderName, cspHeaderValue);
        }
        catch (Exception exception) {
        }
        finally {
            chain.doFilter(request, response);
        }
    }

    public Optional<URI> getCdnUrl() {
        try {
            boolean isCdnUrlEnabled = this.staticAssetsProvider.isEnabled();
            String cdnUrlString = this.staticAssetsProvider.getUrl();
            if (!isCdnUrlEnabled) {
                return Optional.empty();
            }
            if (cdnUrlString == null || cdnUrlString.isEmpty()) {
                return Optional.empty();
            }
            URI canonicalURI = this.getCanonicalUrl(cdnUrlString);
            return Optional.of(canonicalURI);
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    private void addBaseUrlAndReportURLToCspPolicy(final HttpServletRequest httpRequest, ContentSecurityPolicy cspPolicy) {
        final Optional<URI> baseUrl = this.getBaseUrl(httpRequest);
        final Optional<URI> configuredBaseUrl = this.getConfiguredBaseUrl();
        final Optional<URI> cdnUrl = this.getCdnUrl();
        cspPolicy.addCspFragment(new CspFragment(){

            public Set<CspDirective> getCSPDirectives() {
                return Set.of(CspDirective.SCRIPT_SRC, CspDirective.REPORT_URI);
            }

            public Set<URI> getCSPOrigins(CspDirective directive) {
                if (CspDirective.SCRIPT_SRC.equals((Object)directive)) {
                    HashSet<URI> scriptSrcOrigins = new HashSet<URI>();
                    baseUrl.ifPresent(scriptSrcOrigins::add);
                    configuredBaseUrl.ifPresent(scriptSrcOrigins::add);
                    cdnUrl.ifPresent(scriptSrcOrigins::add);
                    return scriptSrcOrigins;
                }
                if (CspDirective.REPORT_URI.equals((Object)directive)) {
                    return Set.of(URI.create(httpRequest.getContextPath() + "/rest/csp/latest/csp-report"));
                }
                return Set.of();
            }

            public Set<String> getUrlPatterns() {
                return Set.of();
            }
        });
    }

    private Optional<URI> getConfiguredBaseUrl() {
        try {
            String configuredBaseUrlString = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            return Optional.of(this.getCanonicalUrl(configuredBaseUrlString));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    private Optional<URI> getBaseUrl(HttpServletRequest httpServletRequest) {
        try {
            StringBuffer httpRequestUrl = httpServletRequest.getRequestURL();
            if (httpRequestUrl == null || httpRequestUrl.isEmpty()) {
                throw new URISyntaxException("Request URL is null or empty", "Cannot determine base URL");
            }
            return Optional.of(this.getCanonicalUrl(httpRequestUrl.toString()));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    private URI getCanonicalUrl(String httpRequestUrl) throws URISyntaxException {
        if (httpRequestUrl == null || httpRequestUrl.isEmpty()) {
            throw new URISyntaxException("Request URL is null or empty", "Cannot determine base URL");
        }
        URI requestURL = new URI(httpRequestUrl);
        if (requestURL.getScheme() == null || requestURL.getHost() == null) {
            throw new URISyntaxException(httpRequestUrl, "Invalid URL: Scheme or host is missing");
        }
        StringBuilder baseUrlBuilder = new StringBuilder(requestURL.getScheme());
        baseUrlBuilder.append("://");
        baseUrlBuilder.append(requestURL.getHost());
        if (requestURL.getPort() != -1 && requestURL.getPort() != 80 && requestURL.getPort() != 443) {
            baseUrlBuilder.append(":").append(requestURL.getPort());
        }
        return new URI(baseUrlBuilder.toString());
    }

    private String getNonce(String cspHeader) {
        try {
            Matcher matcher = NONCE_PATTERN.matcher(cspHeader);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public void destroy() {
    }
}

