/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.plugin.internal.logger;

import com.atlassian.sal.api.ApplicationProperties;
import java.io.File;
import java.net.URI;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.springframework.lang.NonNull;

public class CspLoggerConfigurationFactory
extends ConfigurationFactory {
    private static final String ALL_TYPES = "*";
    private static final String CONFIG_NAME = "CspLoggerConfiguration";
    private static final String FILE_PATTERN_SUFFIX = ".%i";
    private static final String LOG_SIZE_LIMIT = "10MB";
    private static final String MAX_BACKUP_FILES = "5";
    private static final String CSP_LOG_DIRECTORY_NAME = "logs";
    private static final String CSP_VIOLATIONS_LOG_FILENAME = "csp-violations.log";
    private static final String DEFAULT_EMPTY_LOG_PATH = "";
    ApplicationProperties applicationProperties;

    public CspLoggerConfigurationFactory(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        return this.createDefaultConfiguration();
    }

    private String getLogFilePath() {
        Objects.requireNonNull(this.applicationProperties, "The application properties is mandatory.");
        return this.applicationProperties.getLocalHomeDirectory().map(homeDirectoryPath -> new File(String.valueOf(homeDirectoryPath), CSP_LOG_DIRECTORY_NAME)).map(logDir -> new File(String.valueOf(logDir), CSP_VIOLATIONS_LOG_FILENAME)).map(File::getAbsolutePath).orElse(DEFAULT_EMPTY_LOG_PATH);
    }

    @NonNull
    public Configuration createDefaultConfiguration() {
        ConfigurationBuilder builder = CspLoggerConfigurationFactory.newConfigurationBuilder();
        this.configureBaseSettings((ConfigurationBuilder<BuiltConfiguration>)builder);
        String logFilePath = this.getLogFilePath();
        LayoutComponentBuilder layout = this.createLayout((ConfigurationBuilder<BuiltConfiguration>)builder);
        this.createRollingFileAppender((ConfigurationBuilder<BuiltConfiguration>)builder, logFilePath, layout);
        this.configureRootLogger((ConfigurationBuilder<BuiltConfiguration>)builder);
        return (Configuration)builder.build();
    }

    private void configureBaseSettings(ConfigurationBuilder<BuiltConfiguration> builder) {
        builder.setStatusLevel(Level.WARN);
        builder.setConfigurationName(CONFIG_NAME);
    }

    private LayoutComponentBuilder createLayout(ConfigurationBuilder<BuiltConfiguration> builder) {
        return (LayoutComponentBuilder)((LayoutComponentBuilder)((LayoutComponentBuilder)builder.newLayout("JsonLayout").addAttribute("compact", "true")).addAttribute("eventEol", "true")).addAttribute("objectMessageAsJsonObject", "true");
    }

    private void createRollingFileAppender(ConfigurationBuilder<BuiltConfiguration> builder, String logFilePath, LayoutComponentBuilder layout) {
        AppenderComponentBuilder appender = ((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("LogToFile", "RollingFile").addAttribute("fileName", logFilePath)).addAttribute("filePattern", logFilePath + FILE_PATTERN_SUFFIX)).add(layout);
        ComponentBuilder<?> policies = this.createRolloverPolicies(builder);
        appender.addComponent(policies);
        appender.addComponent(this.createRolloverStrategy(builder));
        builder.add(appender);
    }

    private ComponentBuilder<?> createRolloverPolicies(ConfigurationBuilder<BuiltConfiguration> builder) {
        ComponentBuilder policies = builder.newComponent("Policies");
        policies.addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", LOG_SIZE_LIMIT));
        return policies;
    }

    private ComponentBuilder<?> createRolloverStrategy(ConfigurationBuilder<BuiltConfiguration> builder) {
        return builder.newComponent("DefaultRolloverStrategy").addAttribute("max", MAX_BACKUP_FILES);
    }

    private void configureRootLogger(ConfigurationBuilder<BuiltConfiguration> builder) {
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(builder.newAppenderRef("LogToFile")));
    }

    protected String[] getSupportedTypes() {
        return new String[]{ALL_TYPES};
    }
}

