/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.plugin.internal.rest;

import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnrestrictedAccess
@Path(value="csp-report")
public class CspReportResource {
    private static final Logger logger = LogManager.getLogger(CspReportResource.class);

    @POST
    @Consumes(value={"application/json", "application/csp-report"})
    public Response logPayload(String payload) {
        try {
            boolean shouldLog = Boolean.getBoolean("enable.csp.violation.logging");
            if (shouldLog) {
                logger.info(payload);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            logger.error("Error processing payload", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An error occurred while processing the payload").build();
        }
    }
}

