/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.storage.config;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.client.RedirectUriSuffixGenerator;
import com.atlassian.oauth2.client.api.exceptions.ValidationException;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigStorageService;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.client.api.storage.event.ClientConfigurationCreatedEvent;
import com.atlassian.oauth2.client.api.storage.event.ClientConfigurationDeletedEvent;
import com.atlassian.oauth2.client.api.storage.event.ClientConfigurationUpdatedEvent;
import com.atlassian.oauth2.client.api.storage.event.ClientTokenDeletedEvent;
import com.atlassian.oauth2.client.api.storage.token.exception.ConfigurationNotFoundException;
import com.atlassian.oauth2.client.exceptions.HttpsValidationException;
import com.atlassian.oauth2.client.lib.web.AuthorizationCodeFlowUrlsProvider;
import com.atlassian.oauth2.client.storage.config.dao.ClientConfigStore;
import com.atlassian.oauth2.client.storage.token.dao.ClientTokenStore;
import com.atlassian.oauth2.client.util.ClientHttpsValidator;
import com.atlassian.oauth2.common.rest.validator.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;

public class DefaultClientConfigStorageService
implements ClientConfigStorageService {
    private final ClientConfigStore clientConfigStore;
    private final ClientTokenStore clientTokenStore;
    private final EventPublisher eventPublisher;
    private final ClientHttpsValidator clientHttpsValidator;
    private final I18nResolver i18nResolver;
    private final RedirectUriSuffixGenerator redirectUriSuffixGenerator;
    private final AuthorizationCodeFlowUrlsProvider authorizationCodeFlowUrlsProvider;

    public DefaultClientConfigStorageService(ClientConfigStore clientConfigStore, ClientTokenStore clientTokenStore, EventPublisher eventPublisher, ClientHttpsValidator clientHttpsValidator, I18nResolver i18nResolver, RedirectUriSuffixGenerator redirectUriSuffixGenerator, AuthorizationCodeFlowUrlsProvider authorizationCodeFlowUrlsProvider) {
        this.clientConfigStore = clientConfigStore;
        this.clientTokenStore = clientTokenStore;
        this.eventPublisher = eventPublisher;
        this.clientHttpsValidator = clientHttpsValidator;
        this.i18nResolver = i18nResolver;
        this.redirectUriSuffixGenerator = redirectUriSuffixGenerator;
        this.authorizationCodeFlowUrlsProvider = authorizationCodeFlowUrlsProvider;
    }

    @Nonnull
    public ClientConfigurationEntity save(@Nonnull ClientConfigurationEntity clientConfiguration) throws ConfigurationNotFoundException {
        ClientConfigurationEntity savedEntity;
        if (clientConfiguration.getId() == null) {
            savedEntity = this.clientConfigStore.create(clientConfiguration);
            this.eventPublisher.publish((Object)new ClientConfigurationCreatedEvent(savedEntity.getId()));
        } else {
            savedEntity = this.clientConfigStore.update(clientConfiguration);
            this.eventPublisher.publish((Object)new ClientConfigurationUpdatedEvent(savedEntity.getId()));
        }
        return savedEntity;
    }

    public void delete(@Nonnull String id) throws ConfigurationNotFoundException {
        List<String> removedTokens = this.clientTokenStore.deleteWithConfigId(id);
        this.clientConfigStore.delete(id);
        this.eventPublisher.publish((Object)new ClientConfigurationDeletedEvent(id));
        removedTokens.forEach(token -> this.eventPublisher.publish((Object)new ClientTokenDeletedEvent(token)));
    }

    @Nonnull
    public Optional<ClientConfigurationEntity> getById(@Nonnull String id) {
        return Optional.ofNullable(this.clientConfigStore.getById(id));
    }

    @Nonnull
    public ClientConfigurationEntity getByIdOrFail(@Nonnull String id) throws ConfigurationNotFoundException {
        return this.clientConfigStore.getByIdOrFail(id);
    }

    public Optional<ClientConfigurationEntity> getByName(String configName) {
        return this.clientConfigStore.getByName(configName);
    }

    @Nonnull
    public List<ClientConfigurationEntity> list() {
        return this.clientConfigStore.list();
    }

    public boolean isNameUnique(@Nullable String id, @Nonnull String name) {
        return this.clientConfigStore.isNameUnique(id, name);
    }

    public String generateRedirectUrl(@Nonnull String authorizationUrl) throws ValidationException {
        this.enforceHttps();
        String suffix = this.redirectUriSuffixGenerator.generateRedirectUriSuffix(authorizationUrl);
        return this.authorizationCodeFlowUrlsProvider.getRedirectUri(suffix).toString();
    }

    private void enforceHttps() throws ValidationException {
        if (this.clientHttpsValidator.isBaseUrlHttpsRequired() && !this.clientHttpsValidator.isBaseUrlHttps()) {
            throw new HttpsValidationException(ErrorCollection.forMessage(this.i18nResolver.getText("oauth2.integrations.insecure.base.url.error.message")));
        }
    }
}

