/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.storage.token.dao;

import com.atlassian.annotations.Internal;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.oauth2.client.api.storage.token.exception.TokenNotFoundException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

@Internal
public interface ClientTokenStore {
    @Nonnull
    public ClientTokenEntity create(@Nonnull ClientTokenEntity var1);

    @Nonnull
    public ClientTokenEntity create(@Nonnull ClientToken var1, @Nullable String var2, @Nonnull String var3);

    @Nonnull
    public Optional<ClientTokenEntity> update(@Nonnull ClientTokenEntity var1);

    @Nonnull
    public ClientTokenEntity updateOrFail(@Nonnull ClientTokenEntity var1) throws TokenNotFoundException;

    public void delete(@Nonnull String var1) throws TokenNotFoundException;

    public List<String> deleteWithConfigId(@Nonnull String var1);

    public List<String> deleteTokensExpiringBefore(@Nonnull Instant var1);

    public List<String> deleteTokensUnrecoverableSince(@Nonnull Instant var1);

    @Nullable
    public ClientTokenEntity getById(@Nonnull String var1);

    @Nonnull
    public ClientTokenEntity getByIdOrFail(@Nonnull String var1) throws TokenNotFoundException;

    public Optional<ClientTokenEntity> getByExternalIdAndConfigId(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    public List<ClientTokenEntity> getAccessTokensExpiringBefore(@Nonnull Instant var1);

    @Nonnull
    public List<ClientTokenEntity> getRefreshTokensExpiringBefore(@Nonnull Instant var1);

    @Nonnull
    public List<ClientTokenEntity> list();

    public boolean deleteByTokenValue(String var1);
}

