/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.data;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.client.api.storage.config.ProviderType;
import com.atlassian.oauth2.client.properties.SystemProperty;
import com.atlassian.oauth2.client.util.ClientHttpsValidator;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Version;

public class PluginDataProvider
implements WebResourceDataProvider {
    private static final Map<String, Set<String>> SUPPORTED_PROVIDER_TYPES = ImmutableMap.builder().put((Object)GrantType.CLIENT_CREDENTIALS_GRANT.getName(), (Object)ImmutableSet.of((Object)ProviderType.GENERIC.getKey(), (Object)ProviderType.MICROSOFT.getKey())).put((Object)GrantType.AUTHORIZATION_CODE_GRANT.getName(), (Object)ImmutableSet.of((Object)ProviderType.GENERIC.getKey(), (Object)ProviderType.MICROSOFT.getKey(), (Object)ProviderType.GOOGLE.getKey())).build();
    private static final Map<String, String> CLIENT_CREDENTIALS_MINIMUM_SUPPORTED_VERSION = ImmutableMap.of((Object)"jira", (Object)"9.17.0", (Object)"crowd", (Object)"7.0.0");
    private final UserManager userManager;
    private final ClientHttpsValidator clientHttpsValidator;
    private final ApplicationProperties applicationProperties;
    private final HelpPathResolver helpPathResolver;

    public PluginDataProvider(UserManager userManager, ClientHttpsValidator clientHttpsValidator, ApplicationProperties applicationProperties, HelpPathResolver helpPathResolver) {
        this.userManager = userManager;
        this.clientHttpsValidator = clientHttpsValidator;
        this.applicationProperties = applicationProperties;
        this.helpPathResolver = helpPathResolver;
    }

    public Jsonable get() {
        Gson gson = new Gson();
        ImmutableMap data = ImmutableMap.builder().put((Object)"isAuthorized", (Object)this.isSystemAdmin()).put((Object)"isHttpsRequired", (Object)this.clientHttpsValidator.isOAuthProviderUrlHttpsRequired()).put((Object)"isBaseUrlHttpsRequired", (Object)this.clientHttpsValidator.isBaseUrlHttpsRequired()).put((Object)"isBaseUrlHttps", (Object)this.clientHttpsValidator.isBaseUrlHttps()).put((Object)"baseUrl", (Object)this.clientHttpsValidator.getBaseUrl()).put((Object)"product", (Object)this.applicationProperties.getDisplayName()).put((Object)"links", this.getHelpLinks()).put((Object)"supportedGrantTypes", this.getSupportedGrantTypes()).put((Object)"supportedProviderTypes", SUPPORTED_PROVIDER_TYPES).build();
        return writer -> gson.toJson((Object)data, (Appendable)writer);
    }

    private Set<String> getSupportedGrantTypes() {
        return this.isClientCredentialsEnabled() != false ? ImmutableSet.of((Object)GrantType.AUTHORIZATION_CODE_GRANT.getName(), (Object)GrantType.CLIENT_CREDENTIALS_GRANT.getName()) : ImmutableSet.of((Object)GrantType.AUTHORIZATION_CODE_GRANT.getName());
    }

    @VisibleForTesting
    protected Boolean isClientCredentialsEnabled() {
        if (!SystemProperty.CLIENT_CREDENTIALS_GRANT_TYPE_DISABLED.getValue().booleanValue()) {
            Version productVersionTrimmed = Version.parseVersion((String)this.applicationProperties.getVersion().split("-")[0]);
            return CLIENT_CREDENTIALS_MINIMUM_SUPPORTED_VERSION.entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equals(this.applicationProperties.getPlatformId()) && productVersionTrimmed.compareTo(Version.parseVersion((String)((String)entry.getValue()))) >= 0);
        }
        return false;
    }

    private boolean isSystemAdmin() {
        return this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey());
    }

    private String getHelpPathForProduct(String helpPathKey) {
        String productHelpPathKey = helpPathKey + "." + this.applicationProperties.getDisplayName().toLowerCase();
        return StringUtils.defaultString((String)this.setJiraHelplink(this.helpPathResolver.getHelpPath(productHelpPathKey).getUrl()));
    }

    private String setJiraHelplink(String url) {
        if (this.applicationProperties.getPlatformId().equals("jira")) {
            if (url.contains("/jira/jcore")) {
                return url.replace("jcore", "jadm");
            }
            if (url.contains("/jira/jsw")) {
                return url.replace("jsw", "jadm");
            }
            if (url.contains("/jira/jsd")) {
                return url.replace("jsd", "jadm");
            }
            return url;
        }
        return url;
    }

    private Map<String, String> getHelpLinks() {
        return ImmutableMap.of((Object)"configureOutgoingLink", (Object)this.getHelpPathForProduct("help.configure.outgoing.link"));
    }
}

