/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav;

import com.atlassian.confluence.extra.webdav.ConfluenceDavSession;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSessionStore;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.user.User;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={DavSessionProvider.class})
public class ConfluenceDavSessionProviderImpl
implements DavSessionProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceDavSessionProviderImpl.class);
    private final UserAccessor userAccessor;
    private final ConfluenceDavSessionStore confluenceDavSessionStore;
    private final HttpContext httpContext;

    @Autowired
    public ConfluenceDavSessionProviderImpl(@ComponentImport UserAccessor userAccessor, ConfluenceDavSessionStore confluenceDavSessionStore, @ComponentImport HttpContext httpContext) {
        this.userAccessor = userAccessor;
        this.confluenceDavSessionStore = confluenceDavSessionStore;
        this.httpContext = httpContext;
    }

    protected String[] getCredentialTokens(HttpServletRequest httpServletRequest) throws IOException, DavException {
        String[] authorizationHeaderTokens = StringUtils.split((String)StringUtils.trim((String)httpServletRequest.getHeader("Authorization")), (char)' ');
        if (null == authorizationHeaderTokens) {
            throw new DavException(401, "Need authentication");
        }
        if (authorizationHeaderTokens.length < 2) {
            throw new IOException("Malformed Authorization header: " + httpServletRequest.getHeader("Authorization"));
        }
        String authorizationHeader = authorizationHeaderTokens[1];
        if (StringUtils.isBlank((CharSequence)authorizationHeader)) {
            throw new IOException("Unable to read Authorization header.");
        }
        String userNameAndPassword = new String(Base64.decodeBase64((byte[])authorizationHeader.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        int indexOfColon = userNameAndPassword.indexOf(58);
        if (indexOfColon > 0) {
            String userName = userNameAndPassword.substring(0, indexOfColon);
            String password = indexOfColon < userNameAndPassword.length() - 1 ? userNameAndPassword.substring(indexOfColon + 1) : "";
            return new String[]{userName, password};
        }
        return new String[0];
    }

    protected String getUserName(HttpServletRequest httpServletRequest) throws IOException, DavException {
        String[] credentialTokens = this.getCredentialTokens(httpServletRequest);
        return credentialTokens.length == 2 ? credentialTokens[0] : null;
    }

    protected String getPassword(HttpServletRequest httpServletRequest) throws IOException, DavException {
        String[] credentialTokens = this.getCredentialTokens(httpServletRequest);
        return credentialTokens.length == 2 ? credentialTokens[1] : null;
    }

    protected ConfluenceDavSession getConfluenceDavSession(HttpServletRequest httpServletRequest) throws DavException {
        ConfluenceDavSession davSession;
        try {
            davSession = (ConfluenceDavSession)httpServletRequest.getSession().getAttribute(ConfluenceDavSession.class.getName());
        }
        catch (ClassCastException cce) {
            httpServletRequest.getSession().removeAttribute(ConfluenceDavSession.class.getName());
            return null;
        }
        if (davSession != null) {
            return davSession;
        }
        log.debug("ConfluenceDavSession not found in HttpSession. Trying AuthenticatedUserThreadLocal.");
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            log.debug("Found user {} in AuthenticatedUserThreadLocal. Returning a new ConfluenceDavSession based on it.", (Object)user.getName());
            return new ConfluenceDavSession(user.getName());
        }
        try {
            String userName = this.getUserName(httpServletRequest);
            String password = this.getPassword(httpServletRequest);
            log.debug("Trying to find an existing session for {}", (Object)userName);
            if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)password) && this.authenticateWithSeraphAuthenticator(userName, password)) {
                return this.getConfluenceDavSessionFromSessionMap(userName);
            }
            return null;
        }
        catch (AuthenticatorException ae) {
            log.error("Unable to authenticate using the configured Seraph authenticator.", (Throwable)ae);
            throw new DavException(500, (Throwable)ae);
        }
        catch (IOException ioe) {
            log.error("Unable to get user name and/or password from the Authenticate header.", (Throwable)ioe);
            throw new DavException(500, (Throwable)ioe);
        }
    }

    protected void setConfluenceDavSessionIntoHttpSession(HttpServletRequest httpServletRequest, ConfluenceDavSession confluenceDavSession) {
        httpServletRequest.getSession().setAttribute(ConfluenceDavSession.class.getName(), (Object)confluenceDavSession);
    }

    private boolean authenticateWithSeraphAuthenticator(String userName, String password) throws AuthenticatorException {
        return SeraphUtils.authenticate((HttpServletRequest)this.httpContext.getActiveRequest(), (HttpServletResponse)this.httpContext.getActiveResponse(), () -> userName, (String)password);
    }

    private ConfluenceDavSession authenticate(HttpServletRequest httpServletRequest) throws DavException {
        try {
            String userName = this.getUserName(httpServletRequest);
            String password = this.getPassword(httpServletRequest);
            log.debug("User name: {}", (Object)userName);
            if (null == userName) {
                throw new DavException(401, "User name not specified.");
            }
            if (null == password) {
                throw new DavException(401, "Password not specified.");
            }
            if (this.authenticateWithSeraphAuthenticator(userName, password)) {
                return new ConfluenceDavSession(userName);
            }
            throw new DavException(401, "Bad user name or password.");
        }
        catch (AuthenticatorException | IOException ae) {
            throw new DavException(500, ae);
        }
    }

    public boolean attachSession(WebdavRequest request) throws DavException {
        HttpServletRequest req = JakartaAdapters.asJakarta((javax.servlet.http.HttpServletRequest)request);
        ConfluenceDavSession confluenceDavSession = this.getConfluenceDavSession(req);
        if (null == confluenceDavSession) {
            log.debug("Looks like this request is not authenticated. We'll try to authenticate our user now.");
            confluenceDavSession = this.authenticate(req);
        }
        confluenceDavSession.setUserAgent(request.getHeader("User-Agent"));
        confluenceDavSession.updateActivityTimestamp();
        confluenceDavSession.setCurrentlyBeingUsed(true);
        this.setConfluenceDavSessionIntoSessionMap(confluenceDavSession);
        this.setConfluenceDavSessionIntoHttpSession(req, confluenceDavSession);
        request.setDavSession((DavSession)confluenceDavSession);
        AuthenticatedUserThreadLocal.set((ConfluenceUser)FindUserHelper.getUser((User)this.userAccessor.getUser(confluenceDavSession.getUserName())));
        return true;
    }

    public void releaseSession(WebdavRequest request) {
        ConfluenceDavSession confluenceDavSession = (ConfluenceDavSession)request.getDavSession();
        if (null != confluenceDavSession) {
            confluenceDavSession.setCurrentlyBeingUsed(false);
            this.setConfluenceDavSessionIntoSessionMap(confluenceDavSession);
        }
        AuthenticatedUserThreadLocal.set(null);
        request.setDavSession(null);
    }

    private void setConfluenceDavSessionIntoSessionMap(ConfluenceDavSession confluenceDavSession) {
        this.confluenceDavSessionStore.mapSession(confluenceDavSession, confluenceDavSession.getUserName());
    }

    protected ConfluenceDavSession getConfluenceDavSessionFromSessionMap(String userName) {
        return this.confluenceDavSessionStore.getSession(userName);
    }
}

