/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettings;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettingsFactory;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSession;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSessionStore;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSessionTask;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ConfluenceDavSessionStore.class})
@ParametersAreNonnullByDefault
public class PluginSettingsConfluenceDavSessionStore
implements ConfluenceDavSessionStore {
    private static final Logger logger = LoggerFactory.getLogger(PluginSettingsConfluenceDavSessionStore.class);
    public static final String WEBDAV_SESSIONS_NAMESPACE = "com.atlassian.confluence.extra.webdav.sessions";
    private final ExtendedPluginSettings pluginSettings;
    private final long sessionTimeoutInMillis;
    private final ConfluenceJsonObjectMapper jsonObjectMapper = new ConfluenceJsonObjectMapper();
    private static final long DEFAULT_SESSION_TIMEOUT = 1800000L;

    @VisibleForTesting
    PluginSettingsConfluenceDavSessionStore(ExtendedPluginSettingsFactory pluginSettingsFactory, long sessionTimeoutInMillis) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(WEBDAV_SESSIONS_NAMESPACE);
        this.sessionTimeoutInMillis = sessionTimeoutInMillis;
    }

    @Autowired
    public PluginSettingsConfluenceDavSessionStore(@ComponentImport ExtendedPluginSettingsFactory pluginSettingsFactory) {
        this(pluginSettingsFactory, 1800000L);
    }

    @Override
    public void mapSession(ConfluenceDavSession davSession, String userName) {
        try {
            String davSessionJson = this.jsonObjectMapper.writeValueAsString((Object)davSession);
            this.pluginSettings.put(userName, (Object)davSessionJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public ConfluenceDavSession getSession(String userName) {
        String sessionJson = (String)this.pluginSettings.get(userName);
        try {
            return (ConfluenceDavSession)this.jsonObjectMapper.readValue(sessionJson, ConfluenceDavSession.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSessionExpired(ConfluenceDavSession confluenceDavSession) {
        return System.currentTimeMillis() - confluenceDavSession.getLastActivityTimestamp() > this.sessionTimeoutInMillis && !confluenceDavSession.isCurrentlyBeingUsed();
    }

    @Override
    public void invalidateExpiredSessions() {
        Set<String> uniqueSessionKeys = this.getSessionKeys();
        int sessionSize = uniqueSessionKeys.size();
        if (sessionSize > 100) {
            logger.warn("There are {} active WebDAV sessions just before invalidation. Just thought of telling you that because there seems to be an unusual number of users using the WebDAV plugin.", (Object)sessionSize);
        }
        for (String sessionKey : uniqueSessionKeys) {
            ConfluenceDavSession confluenceDavSession = this.getSession(sessionKey);
            if (null == confluenceDavSession || !this.isSessionExpired(confluenceDavSession)) continue;
            this.pluginSettings.remove(sessionKey);
        }
    }

    private Set<String> getSessionKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.pluginSettings.getKeys()) {
            keys.add(key);
        }
        return keys;
    }

    @Override
    public void executeTaskOnSessions(ConfluenceDavSessionTask confluenceDavSessionTask) {
        Set<String> uniqueSessionKeys = this.getSessionKeys();
        for (String sessionKey : uniqueSessionKeys) {
            ConfluenceDavSession confluenceDavSession = this.getSession(sessionKey);
            confluenceDavSessionTask.execute(confluenceDavSession);
            if (confluenceDavSession == null) continue;
            this.mapSession(confluenceDavSession, confluenceDavSession.getUserName());
        }
    }
}

