/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav;

import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.extra.webdav.WebdavSettings;
import com.atlassian.confluence.extra.webdav.WebdavSettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={WebdavSettingsManager.class})
public class PluginSettingsWebdavSettingsManager
implements WebdavSettingsManager {
    public static final String SETTINGS_KEY = "com.atlassian.confluence.extra.webdav-2.0.settings";
    private final PluginSettings globalPluginSettings;
    private final ConfluenceJsonObjectMapper jsonObjectMapper = new ConfluenceJsonObjectMapper();

    @Autowired
    public PluginSettingsWebdavSettingsManager(@ComponentImport @Qualifier(value="extendedPluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory) {
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public void save(WebdavSettings webdavSettings) {
        try {
            String serializedSettings = this.jsonObjectMapper.writeValueAsString((Object)webdavSettings);
            this.globalPluginSettings.put(SETTINGS_KEY, (Object)serializedSettings);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WebdavSettings getWebdavSettings() {
        String setting = (String)this.globalPluginSettings.get(SETTINGS_KEY);
        if (setting == null) {
            return new WebdavSettings();
        }
        try {
            return (WebdavSettings)this.jsonObjectMapper.readValue(setting, WebdavSettings.class);
        }
        catch (JsonProcessingException e) {
            return new WebdavSettings();
        }
    }

    @Override
    public boolean isClientInWriteBlacklist(String userAgent) {
        if (null == userAgent) {
            return false;
        }
        for (String regex : this.getWriteBlacklistClients()) {
            if (!Pattern.compile(regex).matcher(userAgent).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getWriteBlacklistClients() {
        return this.getWebdavSettings().getExcludedClientUserAgentRegexes();
    }

    @Override
    public boolean isContentExportsResourceEnabled() {
        return this.getWebdavSettings().isContentExportsResourceEnabled();
    }

    @Override
    public boolean isContentVersionsResourceEnabled() {
        return this.getWebdavSettings().isContentVersionsResourceEnabled();
    }

    @Override
    public boolean isContentUrlResourceEnabled() {
        return this.getWebdavSettings().isContentUrlResourceEnabled();
    }

    @Override
    public boolean isStrictPageResourcePathCheckingDisabled() {
        return this.getWebdavSettings().isStrictPageResourcePathCheckingDisabled();
    }
}

